package ru.yandex.direct.core.entity.adgroupadditionaltargeting.configuration;

import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdditionalTargetingValue;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AuditoriumGeoSegmentsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.CallerReferrersAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidTypesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ContentCategoriesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.DesktopInstalledAppsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.DeviceIdsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.FeaturesInPPAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasLCookieAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasPassportIdAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InterfaceLang;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InterfaceLangsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InternalNetworkAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsDefaultYandexSearchAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsPPLoggedInAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsVirusedAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsYandexPlusAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.MobileInstalledApp;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.MobileInstalledAppsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.PlusUserSegmentsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryOptionsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryReferersAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.SearchTextAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ShowDatesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.SidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.TestIdsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.TimeAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UserAgentsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UuidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.VisitGoalsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexUidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexuidAgeAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YpCookiesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YsCookiesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserEngine;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserEnginesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserName;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceVendor;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceVendorsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsMobileAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsTabletAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsTouchAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsFamiliesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsFamily;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsName;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType;
import ru.yandex.direct.libs.timetarget.TimeTarget;
import ru.yandex.direct.model.ModelProperty;

import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.auditorium_geosegments;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.browser_engines;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.browser_names;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.caller_referrers;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.clid_types;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.clids;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.content_categories;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.desktop_installed_apps;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.device_id;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.device_names;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.device_vendors;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.features_in_pp;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.has_l_cookie;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.has_passport_id;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.interface_langs;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.internal_network;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.is_default_yandex_search;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.is_mobile;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.is_pp_logged_in;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.is_tablet;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.is_touch;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.is_virused;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.is_yandex_plus;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.mobile_installed_apps;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.os_families;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.os_names;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.plus_user_segments;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.query_options;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.query_referers;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.search_text;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.show_dates;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.sids;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.test_ids;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.timetarget;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.user_agent;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.uuid;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.visit_goals;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.yandexuid_age;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.yandexuids;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.yp_cookies;
import static ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType.ys_cookies;

/**
 * Конфигуратор, предоставляющий доступ к внутренней информации таргетингов (напр. свойство VALUE)
 * через {@link AdGroupAdditionalTargetingValueAccessor}
 */
@ParametersAreNonnullByDefault
public class AdGroupAdditionalTargetingsConfigurationProvider {

    private AdGroupAdditionalTargetingsConfigurationProvider() {
    }

    private static final Map<Class<?>, TargetingAccessor<?>> ACCESSORS_MAP = configureAccessors();

    private static Map<Class<?>, TargetingAccessor<?>> configureAccessors() {

        Map<Class<?>, TargetingAccessor<?>> accessorsMap = new HashMap<>();

        // targetings without value (boolean targetings)
        configure(accessorsMap, HasLCookieAdGroupAdditionalTargeting.class, has_l_cookie,
                HasLCookieAdGroupAdditionalTargeting::new);

        configure(accessorsMap, HasPassportIdAdGroupAdditionalTargeting.class, has_passport_id,
                HasPassportIdAdGroupAdditionalTargeting::new);

        configure(accessorsMap, InternalNetworkAdGroupAdditionalTargeting.class, internal_network,
                InternalNetworkAdGroupAdditionalTargeting::new);

        configure(accessorsMap, IsDefaultYandexSearchAdGroupAdditionalTargeting.class, is_default_yandex_search,
                IsDefaultYandexSearchAdGroupAdditionalTargeting::new);

        configure(accessorsMap, IsPPLoggedInAdGroupAdditionalTargeting.class, is_pp_logged_in,
                IsPPLoggedInAdGroupAdditionalTargeting::new);

        configure(accessorsMap, IsVirusedAdGroupAdditionalTargeting.class, is_virused,
                IsVirusedAdGroupAdditionalTargeting::new);

        configure(accessorsMap, IsYandexPlusAdGroupAdditionalTargeting.class, is_yandex_plus,
                IsYandexPlusAdGroupAdditionalTargeting::new);

        configure(accessorsMap, IsMobileAdGroupAdditionalTargeting.class, is_mobile,
                IsMobileAdGroupAdditionalTargeting::new);

        configure(accessorsMap, IsTabletAdGroupAdditionalTargeting.class, is_tablet,
                IsTabletAdGroupAdditionalTargeting::new);

        configure(accessorsMap, IsTouchAdGroupAdditionalTargeting.class, is_touch,
                IsTouchAdGroupAdditionalTargeting::new);

        // targetings with simple value
        configure(accessorsMap, YandexuidAgeAdGroupAdditionalTargeting.class, yandexuid_age,
                AdditionalTargetingValue.class, Integer.class, YandexuidAgeAdGroupAdditionalTargeting.VALUE,
                YandexuidAgeAdGroupAdditionalTargeting::new);

        // targetings with collection values
        configure(accessorsMap, AuditoriumGeoSegmentsAdGroupAdditionalTargeting.class, auditorium_geosegments,
                Set.class, Long.class, AuditoriumGeoSegmentsAdGroupAdditionalTargeting.VALUE,
                AuditoriumGeoSegmentsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, ClidTypesAdGroupAdditionalTargeting.class, clid_types,
                Set.class, Long.class, ClidTypesAdGroupAdditionalTargeting.VALUE,
                ClidTypesAdGroupAdditionalTargeting::new);

        configure(accessorsMap, ClidsAdGroupAdditionalTargeting.class, clids,
                Set.class, Long.class, ClidsAdGroupAdditionalTargeting.VALUE,
                ClidsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, ContentCategoriesAdGroupAdditionalTargeting.class, content_categories,
                Set.class, Long.class, ContentCategoriesAdGroupAdditionalTargeting.VALUE,
                ContentCategoriesAdGroupAdditionalTargeting::new);

        configure(accessorsMap, DesktopInstalledAppsAdGroupAdditionalTargeting.class, desktop_installed_apps,
                Set.class, Long.class, DesktopInstalledAppsAdGroupAdditionalTargeting.VALUE,
                DesktopInstalledAppsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, DeviceIdsAdGroupAdditionalTargeting.class, device_id,
                Set.class, String.class, DeviceIdsAdGroupAdditionalTargeting.VALUE,
                DeviceIdsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, FeaturesInPPAdGroupAdditionalTargeting.class, features_in_pp,
                Set.class, String.class, FeaturesInPPAdGroupAdditionalTargeting.VALUE,
                FeaturesInPPAdGroupAdditionalTargeting::new);

        configure(accessorsMap, InterfaceLangsAdGroupAdditionalTargeting.class, interface_langs,
                Set.class, InterfaceLang.class, InterfaceLangsAdGroupAdditionalTargeting.VALUE,
                InterfaceLangsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, MobileInstalledAppsAdGroupAdditionalTargeting.class, mobile_installed_apps,
                Set.class, MobileInstalledApp.class, MobileInstalledAppsAdGroupAdditionalTargeting.VALUE,
                MobileInstalledAppsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, PlusUserSegmentsAdGroupAdditionalTargeting.class, plus_user_segments,
                Set.class, Long.class, PlusUserSegmentsAdGroupAdditionalTargeting.VALUE,
                PlusUserSegmentsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, QueryOptionsAdGroupAdditionalTargeting.class, query_options,
                Set.class, String.class, QueryOptionsAdGroupAdditionalTargeting.VALUE,
                QueryOptionsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, QueryReferersAdGroupAdditionalTargeting.class, query_referers,
                List.class, String.class, QueryReferersAdGroupAdditionalTargeting.VALUE,
                QueryReferersAdGroupAdditionalTargeting::new);

        configure(accessorsMap, SearchTextAdGroupAdditionalTargeting.class, search_text,
                Set.class, String.class, SearchTextAdGroupAdditionalTargeting.VALUE,
                SearchTextAdGroupAdditionalTargeting::new);

        configure(accessorsMap, ShowDatesAdGroupAdditionalTargeting.class, show_dates,
                Set.class, LocalDate.class, ShowDatesAdGroupAdditionalTargeting.VALUE,
                ShowDatesAdGroupAdditionalTargeting::new);

        configure(accessorsMap, SidsAdGroupAdditionalTargeting.class, sids,
                Set.class, Long.class, SidsAdGroupAdditionalTargeting.VALUE,
                SidsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, TestIdsAdGroupAdditionalTargeting.class, test_ids,
                Set.class, Long.class, TestIdsAdGroupAdditionalTargeting.VALUE,
                TestIdsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, UserAgentsAdGroupAdditionalTargeting.class, user_agent,
                List.class, String.class, UserAgentsAdGroupAdditionalTargeting.VALUE,
                UserAgentsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, UuidsAdGroupAdditionalTargeting.class, uuid,
                Set.class, String.class, UuidsAdGroupAdditionalTargeting.VALUE,
                UuidsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, VisitGoalsAdGroupAdditionalTargeting.class, visit_goals,
                Set.class, Long.class, VisitGoalsAdGroupAdditionalTargeting.VALUE,
                VisitGoalsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, YandexUidsAdGroupAdditionalTargeting.class, yandexuids,
                List.class, String.class, YandexUidsAdGroupAdditionalTargeting.VALUE,
                YandexUidsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, YpCookiesAdGroupAdditionalTargeting.class, yp_cookies,
                Set.class, String.class, YpCookiesAdGroupAdditionalTargeting.VALUE,
                YpCookiesAdGroupAdditionalTargeting::new);

        configure(accessorsMap, YsCookiesAdGroupAdditionalTargeting.class, ys_cookies,
                Set.class, String.class, YsCookiesAdGroupAdditionalTargeting.VALUE,
                YsCookiesAdGroupAdditionalTargeting::new);

        configure(accessorsMap, BrowserEnginesAdGroupAdditionalTargeting.class, browser_engines,
                List.class, BrowserEngine.class, BrowserEnginesAdGroupAdditionalTargeting.VALUE,
                BrowserEnginesAdGroupAdditionalTargeting::new);

        configure(accessorsMap, BrowserNamesAdGroupAdditionalTargeting.class, browser_names,
                List.class, BrowserName.class, BrowserNamesAdGroupAdditionalTargeting.VALUE,
                BrowserNamesAdGroupAdditionalTargeting::new);

        configure(accessorsMap, DeviceNamesAdGroupAdditionalTargeting.class, device_names,
                List.class, String.class, DeviceNamesAdGroupAdditionalTargeting.VALUE,
                DeviceNamesAdGroupAdditionalTargeting::new);

        configure(accessorsMap, DeviceVendorsAdGroupAdditionalTargeting.class, device_vendors,
                List.class, DeviceVendor.class, DeviceVendorsAdGroupAdditionalTargeting.VALUE,
                DeviceVendorsAdGroupAdditionalTargeting::new);

        configure(accessorsMap, OsFamiliesAdGroupAdditionalTargeting.class, os_families,
                List.class, OsFamily.class, OsFamiliesAdGroupAdditionalTargeting.VALUE,
                OsFamiliesAdGroupAdditionalTargeting::new);

        configure(accessorsMap, OsNamesAdGroupAdditionalTargeting.class, os_names,
                List.class, OsName.class, OsNamesAdGroupAdditionalTargeting.VALUE,
                OsNamesAdGroupAdditionalTargeting::new);

        configure(accessorsMap, TimeAdGroupAdditionalTargeting.class, timetarget,
                List.class, TimeTarget.class, TimeAdGroupAdditionalTargeting.VALUE,
                TimeAdGroupAdditionalTargeting::new);

        configure(accessorsMap, CallerReferrersAdGroupAdditionalTargeting.class, caller_referrers,
                List.class, String.class, CallerReferrersAdGroupAdditionalTargeting.VALUE,
                CallerReferrersAdGroupAdditionalTargeting::new);

        return accessorsMap;
    }

    private static <T extends AdGroupAdditionalTargeting, V, P> void configure(
            Map<Class<?>, TargetingAccessor<?>> accessorsMap,
            Class<T> targetingClass, AdgroupAdditionalTargetingsTargetingType targetingType,
            Class<? super V> valueClass, Class<P> valueParameterClass,
            ModelProperty<T, V> valueProperty,
            Supplier<T> targetingConstructor) {
        //noinspection unchecked
        accessorsMap.put(targetingClass, new TargetingWithParametricValueAccessor<>(
                targetingClass, targetingType,
                (Class<V>) valueClass, valueParameterClass, valueProperty,
                targetingConstructor
        ));
    }

    private static <T extends AdGroupAdditionalTargeting> void configure(
            Map<Class<?>, TargetingAccessor<?>> accessorsMap, Class<T> targetingClass,
            AdgroupAdditionalTargetingsTargetingType targetingType, Supplier<T> targetingConstructor) {

        accessorsMap.put(targetingClass, new TargetingAccessor<>(targetingClass, targetingType, targetingConstructor));
    }

    private static class TargetingAccessor<T extends AdGroupAdditionalTargeting>
            implements AdGroupAdditionalTargetingTypeAccessor<T> {

        private final Class<T> targetingClass;
        private final AdgroupAdditionalTargetingsTargetingType targetingType;
        private final Supplier<? extends T> targetingConstructor;

        TargetingAccessor(Class<T> targetingClass,
                          AdgroupAdditionalTargetingsTargetingType targetingType,
                          Supplier<T> targetingConstructor) {
            this.targetingClass = targetingClass;
            this.targetingType = targetingType;
            this.targetingConstructor = targetingConstructor;
        }

        @Override
        public Class<T> getTargetingClass() {
            return targetingClass;
        }

        @Override
        public AdgroupAdditionalTargetingsTargetingType getTargetingType() {
            return targetingType;
        }

        @Override
        public T newTargeting() {
            return targetingConstructor.get();
        }
    }

    private static class TargetingWithParametricValueAccessor<T extends AdGroupAdditionalTargeting, V, E>
            extends TargetingAccessor<T>
            implements AdGroupAdditionalTargetingWithParametricValueAccessor<T, V> {

        private final Class<V> valueClass;
        private final Class<E> elementClass;
        private final ModelProperty<T, V> valueProperty;

        TargetingWithParametricValueAccessor(Class<T> targetingClass,
                                             AdgroupAdditionalTargetingsTargetingType targetingType,
                                             Class<V> valueClass,
                                             Class<E> elementClass,
                                             ModelProperty<T, V> valueProperty,
                                             Supplier<T> targetingConstructor) {
            super(targetingClass, targetingType, targetingConstructor);
            this.valueClass = valueClass;
            this.elementClass = elementClass;
            this.valueProperty = valueProperty;
        }

        @Override
        public Class<V> getValueClass() {
            return valueClass;
        }

        @Override
        public V getValue(T targeting) {
            return valueProperty.get(targeting);
        }

        @Override
        public void setValue(T targeting, V value) {
            valueProperty.set(targeting, value);
        }

        @Override
        public ModelProperty<T, V> getValueModelProperty() {
            return valueProperty;
        }

        @Override
        public Class<?> getValueParameterClass() {
            return elementClass;
        }
    }

    public static Collection<? extends AdGroupAdditionalTargetingTypeAccessor<?>> getAccessors() {
        return ACCESSORS_MAP.values();
    }

    @Nullable
    public static <T extends AdGroupAdditionalTargeting, E, V extends Collection<E>>
    AdGroupAdditionalTargetingWithParametricValueAccessor<T, V>
    getCollectionValueAccessorByTargeting(T targeting) {
        return getValueAccessorByTargeting(targeting, Collection.class);
    }

    @Nullable
    public static <T extends AdGroupAdditionalTargeting, E, V extends Collection<E>>
    AdGroupAdditionalTargetingWithParametricValueAccessor<T, V>
    getCollectionValueAccessorByTargetingClass(Class<T> targetingClass) {
        return getValueAccessorByTargetingClass(targetingClass, Collection.class);
    }

    @Nullable
    public static <T extends AdGroupAdditionalTargeting, V>
    AdGroupAdditionalTargetingWithParametricValueAccessor<T, V>
    getValueAccessorByTargeting(T targeting, Class<? super V> valueClass) {
        //noinspection unchecked
        return getValueAccessorByTargetingClass((Class<T>) targeting.getClass(), valueClass);
    }

    @Nullable
    public static <T extends AdGroupAdditionalTargeting, V>
    AdGroupAdditionalTargetingWithParametricValueAccessor<T, V>
    getValueAccessorByTargetingClass(Class<T> targetingClass, Class<? super V> valueClass) {
        TargetingAccessor<?> accessor = ACCESSORS_MAP.get(targetingClass);

        if (accessor instanceof AdGroupAdditionalTargetingWithParametricValueAccessor) {
            Class<?> accessorValueClass =
                    ((AdGroupAdditionalTargetingWithParametricValueAccessor<?, ?>) accessor).getValueClass();

            if (valueClass.isAssignableFrom(accessorValueClass)) {
                //noinspection unchecked
                return (AdGroupAdditionalTargetingWithParametricValueAccessor<T, V>) accessor;
            }
        }

        return null;
    }
}
