package ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.typesupport;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType;
import ru.yandex.direct.dbschema.ppc.tables.records.AdgroupAdditionalTargetingsRecord;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

/**
 * Интерфейс классов, которые реализуют зависящую от типа логику работы с дополнительными
 * типами таргетингов в репозиториях: сохранение данных таргетинга в базу, извлечение данных
 * таргетинга из базы, превращение данных из базы в объект AdGroupAdditionalTargeting нужного
 * подкласса с заполненными нужными полями.
 * <p>
 * Один класс отвечает за один тип таргетинга.
 */
@ParametersAreNonnullByDefault
interface AdGroupAdditionalTargetingTypeSupport<T extends AdGroupAdditionalTargeting> {
    Class<T> getTargetingClass();

    AdgroupAdditionalTargetingsTargetingType getDbType();

    T constructFromDb(Record record);

    void addToDbHelper(InsertHelper<AdgroupAdditionalTargetingsRecord> insertHelper, DSLContext dslContext,
                       ClientId clientId, List<T> targetings);
}
