package ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.typesupport;

import java.util.List;
import java.util.function.Supplier;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Record;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargetingJoinType;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargetingMode;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.typesupport.valuefieldmapper.ValueFieldMapper;
import ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType;
import ru.yandex.direct.dbschema.ppc.tables.records.AdgroupAdditionalTargetingsRecord;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.model.ModelProperty;

import static com.google.common.base.Preconditions.checkState;
import static ru.yandex.direct.dbschema.ppc.tables.AdgroupAdditionalTargetings.ADGROUP_ADDITIONAL_TARGETINGS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@ParametersAreNonnullByDefault
public class CommonAdditionalTargetingTypeSupport<T extends AdGroupAdditionalTargeting, R>
        implements AdGroupAdditionalTargetingTypeSupport<T> {
    private final Class<T> targetingClass;
    private final Supplier<T> targetingCreator;
    private final AdgroupAdditionalTargetingsTargetingType dbType;
    private final ModelProperty<T, R> valueProperty;
    private final ValueFieldMapper<R> fieldMapper;

    public static final JooqMapper<AdGroupAdditionalTargeting>
            ADGROUP_ADDITIONAL_TARGETINGS_MAPPER_FOR_COMMON_FIELDS = getCommonFieldsMapper();

    CommonAdditionalTargetingTypeSupport(Class<T> targetingClass, Supplier<T> targetingCreator,
                                         AdgroupAdditionalTargetingsTargetingType dbType) {
        this(targetingClass, targetingCreator, dbType, null, null);
    }

    CommonAdditionalTargetingTypeSupport(Class<T> targetingClass, Supplier<T> targetingCreator,
                                         AdgroupAdditionalTargetingsTargetingType dbType,
                                         @Nullable ModelProperty<T, R> valueProperty,
                                         @Nullable ValueFieldMapper<R> fieldMapper) {
        this.targetingClass = targetingClass;
        this.targetingCreator = targetingCreator;
        this.dbType = dbType;
        this.valueProperty = valueProperty;
        this.fieldMapper = fieldMapper;
    }

    /**
     * Общий маппер для всех наследников {@link AdGroupAdditionalTargeting}
     * Так как логика общая для всех типов таргетингов, она не содержит работу с двумя полями:
     * {@code adgroup_additional_targetings.targeting_type}, т.к. как по нему решается, какого класса объект будет
     * получен
     * {@code adgroup_additional_targetings.value}, т.к. оно заполняется в зависимости от типа таргетинга
     */
    private static JooqMapper<AdGroupAdditionalTargeting> getCommonFieldsMapper() {
        return JooqMapperBuilder.<AdGroupAdditionalTargeting>builder()
                .map(property(AdGroupAdditionalTargeting.ID, ADGROUP_ADDITIONAL_TARGETINGS.ID))
                .map(property(AdGroupAdditionalTargeting.AD_GROUP_ID, ADGROUP_ADDITIONAL_TARGETINGS.PID))
                .map(convertibleProperty(AdGroupAdditionalTargeting.TARGETING_MODE,
                        ADGROUP_ADDITIONAL_TARGETINGS.TARGETING_MODE,
                        AdGroupAdditionalTargetingMode::fromSource,
                        AdGroupAdditionalTargetingMode::toSource))
                .map(convertibleProperty(AdGroupAdditionalTargeting.JOIN_TYPE,
                        ADGROUP_ADDITIONAL_TARGETINGS.VALUE_JOIN_TYPE,
                        AdGroupAdditionalTargetingJoinType::fromSource,
                        AdGroupAdditionalTargetingJoinType::toSource))
                .build();
    }

    private JooqMapperWithSupplier<T> getValueFieldMapper() {
        checkState(fieldMapper != null);
        return JooqMapperWithSupplierBuilder.builder(targetingCreator)
                .map(convertibleProperty(valueProperty, ADGROUP_ADDITIONAL_TARGETINGS.VALUE,
                        fieldMapper::fromJson,
                        fieldMapper::toJson))
                .build();
    }

    @Override
    public Class<T> getTargetingClass() {
        return this.targetingClass;
    }

    @Override
    public AdgroupAdditionalTargetingsTargetingType getDbType() {
        return this.dbType;
    }

    @Override
    public T constructFromDb(Record record) {
        T targeting = targetingCreator.get();
        ADGROUP_ADDITIONAL_TARGETINGS_MAPPER_FOR_COMMON_FIELDS.fromDb(record, targeting);
        if (valueProperty != null) {
            getValueFieldMapper().fromDb(record, targeting);
        }
        return targeting;
    }

    @Override
    public void addToDbHelper(InsertHelper<AdgroupAdditionalTargetingsRecord> insertHelper, DSLContext dslContext,
                              ClientId clientId, List<T> targetings) {
        for (T targeting : targetings) {
            insertHelper = insertHelper
                    .add(ADGROUP_ADDITIONAL_TARGETINGS_MAPPER_FOR_COMMON_FIELDS, targeting)
                    .set(ADGROUP_ADDITIONAL_TARGETINGS.TARGETING_TYPE, dbType);
            if (valueProperty != null) {
                insertHelper.add(getValueFieldMapper(), targeting);
            }
            insertHelper.newRecord();
        }
    }
}
