package ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.typesupport;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.MobileInstalledApp;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.MobileInstalledAppsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.typesupport.valuefieldmapper.ValueFieldMapper;
import ru.yandex.direct.core.entity.mobilecontent.container.MobileAppStoreUrl;
import ru.yandex.direct.core.entity.mobilecontent.repository.MobileContentRepository;
import ru.yandex.direct.core.entity.mobilecontent.util.MobileAppStoreUrlParser;
import ru.yandex.direct.dbschema.ppc.enums.AdgroupAdditionalTargetingsTargetingType;
import ru.yandex.direct.dbschema.ppc.tables.records.AdgroupAdditionalTargetingsRecord;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.utils.JsonUtils;

import static com.google.common.base.Preconditions.checkState;
import static ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.typesupport.CommonAdditionalTargetingTypeSupport.ADGROUP_ADDITIONAL_TARGETINGS_MAPPER_FOR_COMMON_FIELDS;
import static ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.typesupport.valuefieldmapper.ValueFieldMappers.fromTypeReference;
import static ru.yandex.direct.dbschema.ppc.tables.AdgroupAdditionalTargetings.ADGROUP_ADDITIONAL_TARGETINGS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;

@Component
@ParametersAreNonnullByDefault
public class MobileInstalledAppsAdditionalTargetingTypeSupport implements AdGroupAdditionalTargetingTypeSupport<MobileInstalledAppsAdGroupAdditionalTargeting> {
    private static final ValueFieldMapper<Set<MobileInstalledApp>> valueFieldMapper =
            fromTypeReference(JsonUtils.getTypeFactory().constructCollectionType(Set.class, MobileInstalledApp.class));
    private final MobileContentRepository mobileContentRepository;

    @Autowired
    MobileInstalledAppsAdditionalTargetingTypeSupport(
            MobileContentRepository mobileContentRepository) {
        this.mobileContentRepository = mobileContentRepository;
    }

    private JooqMapperWithSupplier<MobileInstalledAppsAdGroupAdditionalTargeting> getValueFieldMapper() {
        return JooqMapperWithSupplierBuilder.builder(MobileInstalledAppsAdGroupAdditionalTargeting::new)
                .map(convertibleProperty(MobileInstalledAppsAdGroupAdditionalTargeting.VALUE,
                        ADGROUP_ADDITIONAL_TARGETINGS.VALUE,
                        valueFieldMapper::fromJson,
                        valueFieldMapper::toJson))
                .build();
    }

    @Override
    public Class<MobileInstalledAppsAdGroupAdditionalTargeting> getTargetingClass() {
        return MobileInstalledAppsAdGroupAdditionalTargeting.class;
    }

    @Override
    public AdgroupAdditionalTargetingsTargetingType getDbType() {
        return AdgroupAdditionalTargetingsTargetingType.mobile_installed_apps;
    }

    @Override
    public MobileInstalledAppsAdGroupAdditionalTargeting constructFromDb(Record record) {
        MobileInstalledAppsAdGroupAdditionalTargeting targeting = new MobileInstalledAppsAdGroupAdditionalTargeting();
        ADGROUP_ADDITIONAL_TARGETINGS_MAPPER_FOR_COMMON_FIELDS.fromDb(record, targeting);
        getValueFieldMapper().fromDb(record, targeting);
        return targeting;
    }

    @Override
    public void addToDbHelper(InsertHelper<AdgroupAdditionalTargetingsRecord> insertHelper, DSLContext dslContext,
                              ClientId clientId, List<MobileInstalledAppsAdGroupAdditionalTargeting> targetings) {
        var parsedUrls = StreamEx.of(targetings)
                .map(MobileInstalledAppsAdGroupAdditionalTargeting::getValue)
                .flatMap(Set::stream)
                .map(MobileInstalledApp::getStoreUrl)
                .map(MobileAppStoreUrlParser::parseStrict)
                .distinct()
                .toList();
        List<Long> mobileContentIds = mobileContentRepository.getOrCreate(dslContext, clientId, parsedUrls);
        // основано на знании, что MobileContentRepository.getOrCreate() возвращает идентификаторы MobileContent
        // в том же порядке, в котором были переданы parsedUrls
        Map<MobileAppStoreUrl, Long> mobileAppStoreUrlMap = EntryStream.zip(parsedUrls, mobileContentIds).toMap();
        for (var targeting : targetings) {
            StreamEx.of(targeting.getValue())
                    .mapToEntry(MobileInstalledApp::getStoreUrl)
                    .mapValues(MobileAppStoreUrlParser::parseStrict)
                    .mapValues(mobileAppStoreUrlMap::get)
                    .peekValues(mobileContentId -> checkState(mobileContentId != null))
                    .forKeyValue(MobileInstalledApp::setMobileContentId);
            insertHelper = insertHelper
                    .add(ADGROUP_ADDITIONAL_TARGETINGS_MAPPER_FOR_COMMON_FIELDS, targeting)
                    .set(ADGROUP_ADDITIONAL_TARGETINGS.TARGETING_TYPE, getDbType())
                    .add(getValueFieldMapper(), targeting);
            insertHelper.newRecord();
        }
    }
}
