package ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.typesupport.valuefieldmapper

import com.fasterxml.jackson.module.kotlin.readValue
import ru.yandex.direct.libs.timetarget.TimeTarget
import ru.yandex.direct.utils.JsonUtils

class TimeTargetFieldMapper : ValueFieldMapper<List<TimeTarget>> {
    override fun fromJson(json: String): List<TimeTarget> {
        val semiSerialized = JsonUtils.getObjectMapper().readValue<List<String>>(json)
        return semiSerialized.map { TimeTarget.parseRawString(it) }
    }

    override fun toJson(obj: List<TimeTarget>): String {
        return JsonUtils.toJson(obj.map { it.toRawFormat() })
    }
}
