package ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.typesupport.valuefieldmapper;

import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.JavaType;

import ru.yandex.direct.utils.JsonUtils;

import static com.google.common.base.Preconditions.checkNotNull;

@ParametersAreNonnullByDefault
public class ValueFieldMappers {
    public static <T> ValueFieldMapper<T> fromFunctions(Function<String, T> fromStringFunction,
                                                        Function<T, String> toStringFunction) {
        return new ValueFieldMapper<>() {
            @Override
            public T fromJson(String json) {
                return fromStringFunction.apply(json);
            }

            @Override
            public String toJson(T obj) {
                return toStringFunction.apply(obj);
            }
        };
    }

    public static <T> ValueFieldMapper<T> fromTypeReference(JavaType typeReference) {
        return fromFunctions(
                val -> JsonUtils.fromJson(checkNotNull(val), typeReference),
                val -> val == null ? null : JsonUtils.toJson(val));
    }
}
