package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.AdGroupAdditionalTargetingRepository;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.AdGroupAdditionalTargetingsValidationService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

@Service
@ParametersAreNonnullByDefault
public class AdGroupAdditionalTargetingFindOrCreateOperationFactory {
    private final ShardHelper shardHelper;
    private final AdGroupAdditionalTargetingRepository additionalTargetingRepository;
    private final AdGroupAdditionalTargetingService adGroupAdditionalTargetingService;
    private final AdGroupAdditionalTargetingsValidationService adGroupAdditionalTargetingsValidationService;
    private final AdGroupRepository adGroupRepository;
    private final AdGroupAdditionalTargetingValidatorSupplier validatorSupplier;

    public AdGroupAdditionalTargetingFindOrCreateOperationFactory(
            ShardHelper shardHelper, AdGroupAdditionalTargetingRepository additionalTargetingRepository,
            AdGroupAdditionalTargetingService adGroupAdditionalTargetingService,
            AdGroupAdditionalTargetingsValidationService adGroupAdditionalTargetingsValidationService,
            AdGroupRepository adGroupRepository,
            AdGroupAdditionalTargetingValidatorSupplier validatorSupplier) {
        this.shardHelper = shardHelper;
        this.additionalTargetingRepository = additionalTargetingRepository;
        this.adGroupAdditionalTargetingService = adGroupAdditionalTargetingService;
        this.adGroupAdditionalTargetingsValidationService = adGroupAdditionalTargetingsValidationService;
        this.adGroupRepository = adGroupRepository;
        this.validatorSupplier = validatorSupplier;
    }

    public AdGroupAdditionalTargetingFindOrCreateOperation newInstance(
            List<AdGroupAdditionalTargeting> targetings,
            boolean partOfComplexOperation,
            ClientId clientId) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new AdGroupAdditionalTargetingFindOrCreateOperation(
                targetings, additionalTargetingRepository, adGroupAdditionalTargetingService,
                adGroupAdditionalTargetingsValidationService, adGroupRepository, partOfComplexOperation, shard,
                clientId);
    }

    public AdGroupAdditionalTargetingValidatorSupplier getValidatorSupplier() {
        return validatorSupplier;
    }
}
