package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.AdGroupAdditionalTargetingRepository;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.container.AdGroupAdditionalTargetingGroupsOperationContainer;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.operation.AddedModelId;
import ru.yandex.direct.operation.PartiallyApplicableOperation;

@Service
@ParametersAreNonnullByDefault
public class AdGroupAdditionalTargetingGroupsUpdateOperationFactory {
    private final ShardHelper shardHelper;
    private final AdGroupAdditionalTargetingRepository additionalTargetingRepository;
    private final AdGroupAdditionalTargetingService adGroupAdditionalTargetingService;
    private final AdGroupAdditionalTargetingFindOrCreateOperationFactory
            adGroupAdditionalTargetingFindOrCreateOperationFactory;
    private final AdGroupRepository adGroupRepository;

    public AdGroupAdditionalTargetingGroupsUpdateOperationFactory(
            ShardHelper shardHelper,
            AdGroupAdditionalTargetingRepository additionalTargetingRepository,
            AdGroupAdditionalTargetingService adGroupAdditionalTargetingService,
            AdGroupAdditionalTargetingFindOrCreateOperationFactory
                    adGroupAdditionalTargetingFindOrCreateOperationFactory,
            AdGroupRepository adGroupRepository) {
        this.shardHelper = shardHelper;
        this.additionalTargetingRepository = additionalTargetingRepository;
        this.adGroupAdditionalTargetingService = adGroupAdditionalTargetingService;
        this.adGroupAdditionalTargetingFindOrCreateOperationFactory =
                adGroupAdditionalTargetingFindOrCreateOperationFactory;
        this.adGroupRepository = adGroupRepository;
    }

    public PartiallyApplicableOperation<List<AddedModelId>> newInstance(
            AdGroupAdditionalTargetingGroupsOperationContainer operationContainer) {
        int shard = shardHelper.getShardByClientIdStrictly(operationContainer.getClientId());
        return new AdGroupAdditionalTargetingGroupsUpdateOperation(
                adGroupAdditionalTargetingService, additionalTargetingRepository,
                adGroupAdditionalTargetingFindOrCreateOperationFactory, adGroupRepository,
                operationContainer,
                shard
        );
    }
}
