package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.AdGroupAdditionalTargetingsValidationService;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;

@Component
public class AdGroupAdditionalTargetingValidatorSupplier {
    protected final AdGroupAdditionalTargetingsValidationService adGroupAdditionalTargetingsValidationService;

    AdGroupAdditionalTargetingValidatorSupplier(
            AdGroupAdditionalTargetingsValidationService adGroupAdditionalTargetingsValidationService) {

        this.adGroupAdditionalTargetingsValidationService = adGroupAdditionalTargetingsValidationService;
    }

    /**
     * Возвращает вадидатор для проверки таргетингов по группам, который принимает сгруппированный список таргетингов
     */
    public Validator<List<List<AdGroupAdditionalTargeting>>, Defect> getGroupValidator() {
        return targetings -> ListValidationBuilder.of(targetings, Defect.class)
                .checkEachBy(adGroupAdditionalTargetingsValidationService::preValidateByGroup)
                .getResult();
    }
}
