package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.AdGroupAdditionalTargetingRepository;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.AdGroupAdditionalTargetingsValidationService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.OperationsUtils;
import ru.yandex.direct.operation.add.AbstractAddOperation;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@ParametersAreNonnullByDefault
public class AdGroupAdditionalTargetingsAddOperation extends AbstractAddOperation<AdGroupAdditionalTargeting, Long> {
    private final AdGroupAdditionalTargetingRepository adGroupAdditionalTargetingRepository;
    private final AdGroupAdditionalTargetingsValidationService adGroupAdditionalTargetingsValidationService;
    private final AdGroupRepository adGroupRepository;

    private final boolean partOfComplexOperation;
    private final int shard;
    private final ClientId clientId;

    AdGroupAdditionalTargetingsAddOperation(
            Applicability applicability,
            List<AdGroupAdditionalTargeting> targetings,
            AdGroupAdditionalTargetingRepository adGroupAdditionalTargetingRepository,
            AdGroupAdditionalTargetingsValidationService adGroupAdditionalTargetingsValidationService,
            AdGroupRepository adGroupRepository, boolean partOfComplexOperation, int shard, ClientId clientId) {
        super(applicability, targetings);
        this.adGroupAdditionalTargetingRepository = adGroupAdditionalTargetingRepository;
        this.adGroupAdditionalTargetingsValidationService = adGroupAdditionalTargetingsValidationService;
        this.adGroupRepository = adGroupRepository;
        this.partOfComplexOperation = partOfComplexOperation;
        this.shard = shard;
        this.clientId = clientId;
    }

    @Override
    protected void validate(ValidationResult<List<AdGroupAdditionalTargeting>, Defect> preValidationResult) {
        new ItemValidationBuilder<>(preValidationResult)
                .checkBy(targetings -> adGroupAdditionalTargetingsValidationService
                        .validate(targetings, partOfComplexOperation));
    }

    @Override
    protected Map<Integer, Long> execute(Map<Integer, AdGroupAdditionalTargeting> validModelsMapToApply) {
        Map<Integer, Long> resultMap = OperationsUtils.applyForMapValues(validModelsMapToApply,
                validModelsToApply -> adGroupAdditionalTargetingRepository.add(shard, clientId, validModelsToApply));
        Set<Long> adGroupIds = listToSet(validModelsMapToApply.values(), AdGroupAdditionalTargeting::getAdGroupId);
        adGroupRepository.actualizeAdGroupsOnChildModification(shard, adGroupIds);
        return resultMap;
    }
}
