package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.AdGroupAdditionalTargetingRepository;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.AdGroupAdditionalTargetingsValidationService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.operation.Applicability;

@Component
@ParametersAreNonnullByDefault
public class AdGroupAdditionalTargetingsAddOperationFactory {
    private final ShardHelper shardHelper;
    private final AdGroupAdditionalTargetingRepository adGroupAdditionalTargetingRepository;
    private final AdGroupAdditionalTargetingsValidationService adGroupAdditionalTargetingsValidationService;
    private final AdGroupRepository adGroupRepository;
    private final AdGroupAdditionalTargetingValidatorSupplier validatorSupplier;

    public AdGroupAdditionalTargetingsAddOperationFactory(
            ShardHelper shardHelper,
            AdGroupAdditionalTargetingRepository adGroupAdditionalTargetingRepository,
            AdGroupAdditionalTargetingsValidationService adGroupAdditionalTargetingsValidationService,
            AdGroupRepository adGroupRepository,
            AdGroupAdditionalTargetingValidatorSupplier validatorSupplier) {
        this.shardHelper = shardHelper;
        this.adGroupAdditionalTargetingRepository = adGroupAdditionalTargetingRepository;
        this.adGroupAdditionalTargetingsValidationService = adGroupAdditionalTargetingsValidationService;
        this.adGroupRepository = adGroupRepository;
        this.validatorSupplier = validatorSupplier;
    }

    public AdGroupAdditionalTargetingsAddOperation newInstance(
            Applicability applicability,
            boolean partOfComplexOperation,
            List<AdGroupAdditionalTargeting> targetings,
            ClientId clientId) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new AdGroupAdditionalTargetingsAddOperation(
                applicability,
                targetings,
                adGroupAdditionalTargetingRepository,
                adGroupAdditionalTargetingsValidationService,
                adGroupRepository, partOfComplexOperation,
                shard,
                clientId
        );
    }

    public AdGroupAdditionalTargetingValidatorSupplier getValidatorSupplier() {
        return validatorSupplier;
    }
}
