package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.AdGroupAdditionalTargetingRepository;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.DeleteAdGroupAdditionalTargetingsValidationService;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.operationwithid.AbstractOperationWithId;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@ParametersAreNonnullByDefault
public class AdGroupAdditionalTargetingsDeleteOperation extends AbstractOperationWithId {
    private final DeleteAdGroupAdditionalTargetingsValidationService deleteAdGroupAdditionalTargetingsValidationService;
    private final int shard;
    private final AdGroupAdditionalTargetingRepository adGroupAdditionalTargetingRepository;
    private final AdGroupRepository adGroupRepository;
    private final DslContextProvider dslContextProvider;

    AdGroupAdditionalTargetingsDeleteOperation(
            DslContextProvider dslContextProvider,
            AdGroupAdditionalTargetingRepository adGroupAdditionalTargetingRepository,
            AdGroupRepository adGroupRepository,
            DeleteAdGroupAdditionalTargetingsValidationService deleteAdGroupAdditionalTargetingsValidationService,
            Applicability applicability,
            int shard, List<Long> ids) {
        super(applicability, ids);
        this.adGroupAdditionalTargetingRepository = adGroupAdditionalTargetingRepository;
        this.adGroupRepository = adGroupRepository;
        this.deleteAdGroupAdditionalTargetingsValidationService = deleteAdGroupAdditionalTargetingsValidationService;
        this.dslContextProvider = dslContextProvider;
        this.shard = shard;
    }

    @Override
    protected ValidationResult<List<Long>, Defect> validate(List<Long> ids) {
        return deleteAdGroupAdditionalTargetingsValidationService.validateDelete(shard, ids);
    }

    @Override
    protected void execute(List<Long> ids) {
        Set<Long> affectedAdGroupIds = adGroupAdditionalTargetingRepository.getAdGroupsByTargetingIds(shard, ids);
        adGroupAdditionalTargetingRepository.deleteByIds(dslContextProvider.ppc(shard), ids);
        adGroupRepository.actualizeAdGroupsOnChildModification(shard, affectedAdGroupIds);
    }
}
