package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.AdGroupAdditionalTargetingRepository;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.DeleteAdGroupAdditionalTargetingsValidationService;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.operation.Applicability;

@Component
@ParametersAreNonnullByDefault
public class AdGroupAdditionalTargetingsDeleteOperationFactory {
    private final AdGroupAdditionalTargetingRepository adGroupAdditionalTargetingRepository;
    private final AdGroupRepository adGroupRepository;
    private final DeleteAdGroupAdditionalTargetingsValidationService deleteAdGroupAdditionalTargetingsValidationService;
    private final DslContextProvider dslContextProvider;

    public AdGroupAdditionalTargetingsDeleteOperationFactory(
            AdGroupAdditionalTargetingRepository adGroupAdditionalTargetingRepository,
            AdGroupRepository adGroupRepository,
            DeleteAdGroupAdditionalTargetingsValidationService deleteAdGroupAdditionalTargetingsValidationService,
            DslContextProvider dslContextProvider) {
        this.adGroupAdditionalTargetingRepository = adGroupAdditionalTargetingRepository;
        this.adGroupRepository = adGroupRepository;
        this.deleteAdGroupAdditionalTargetingsValidationService = deleteAdGroupAdditionalTargetingsValidationService;
        this.dslContextProvider = dslContextProvider;
    }

    public AdGroupAdditionalTargetingsDeleteOperation newInstance(
            Applicability applicability,
            List<Long> ids,
            int shard) {
        return new AdGroupAdditionalTargetingsDeleteOperation(
                dslContextProvider, adGroupAdditionalTargetingRepository, adGroupRepository,
                deleteAdGroupAdditionalTargetingsValidationService, applicability,
                shard, ids
        );
    }
}
