package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InternalAdGroupContainsAdditionalTargetings;
import ru.yandex.direct.dbutil.model.ClientId;

@Service
@ParametersAreNonnullByDefault
public class InternalAdGroupWithAdditionalTargetingsService implements RelationshipService<InternalAdGroupContainsAdditionalTargetings, Long, Long> {
    private final AdGroupAdditionalTargetingService adGroupAdditionalTargetingService;

    @Autowired
    public InternalAdGroupWithAdditionalTargetingsService(AdGroupAdditionalTargetingService adGroupAdditionalTargetingService) {
        this.adGroupAdditionalTargetingService = adGroupAdditionalTargetingService;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> adGroupIds) {
        return StreamEx.of(adGroupAdditionalTargetingService.getTargetingsByAdGroupIds(clientId, adGroupIds))
                .map(AdGroupAdditionalTargeting::getId)
                .toSet();
    }
}
