package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.container;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.container.InternalAdGroupOperationContainer.RequestSource;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.dbutil.model.ClientId;

@ParametersAreNonnullByDefault
public final class AdGroupAdditionalTargetingGroupsOperationContainer {
    private final ClientId clientId;
    private final List<List<AdGroupAdditionalTargeting>> targetingGroups;
    private final List<Long> adGroupIdForTargetingGroups;
    private final RequestSource requestSource;

    public AdGroupAdditionalTargetingGroupsOperationContainer(ClientId clientId,
                                                              List<List<AdGroupAdditionalTargeting>> targetingGroups,
                                                              List<Long> adGroupIdForTargetingGroups,
                                                              RequestSource requestSource) {
        this.clientId = clientId;
        this.targetingGroups = targetingGroups;
        this.adGroupIdForTargetingGroups = adGroupIdForTargetingGroups;
        this.requestSource = requestSource;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public List<List<AdGroupAdditionalTargeting>> getTargetingGroups() {
        return targetingGroups;
    }

    public List<Long> getAdGroupIdForTargetingGroups() {
        return adGroupIdForTargetingGroups;
    }

    public RequestSource getRequestSource() {
        return requestSource;
    }
}
