package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.repository.AdGroupAdditionalTargetingRepository;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.listToSet;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

@Service
@ParametersAreNonnullByDefault
public class DeleteAdGroupAdditionalTargetingsValidationService {
    private final AdGroupAdditionalTargetingRepository repository;

    public DeleteAdGroupAdditionalTargetingsValidationService(
            AdGroupAdditionalTargetingRepository adGroupAdditionalTargetingRepository) {
        this.repository = adGroupAdditionalTargetingRepository;
    }

    public ValidationResult<List<Long>, Defect> validateDelete(int shard, List<Long> ids) {
        Set<Long> existingIds = listToSet(repository.getByIds(shard, ids), AdGroupAdditionalTargeting::getId);

        return ListValidationBuilder.<Long, Defect>of(ids)
                .checkEach(inSet(existingIds), CommonDefects.objectNotFound())
                .getResult();
    }
}
