package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AuditoriumGeoSegmentsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.CallerReferrersAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidTypesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.FeaturesInPPAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasLCookieAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasPassportIdAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InternalNetworkAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsDefaultYandexSearchAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsPPLoggedInAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsVirusedAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsYandexPlusAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.PlusUserSegmentsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryOptionsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryReferersAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.SearchTextAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.SidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.TestIdsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UserAgentsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YpCookiesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YsCookiesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserEnginesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceVendorsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsMobileAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsTabletAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsTouchAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsFamiliesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.util.function.Function.identity;
import static java.util.stream.Collectors.toMap;
import static ru.yandex.direct.core.entity.adgroupadditionaltargeting.UaTraitsConstants.BROWSER_ENGINE_VALID_VALUES;
import static ru.yandex.direct.core.entity.adgroupadditionaltargeting.UaTraitsConstants.BROWSER_NAME_VALID_VALUES;
import static ru.yandex.direct.core.entity.adgroupadditionaltargeting.UaTraitsConstants.DEVICE_VENDOR_VALID_VALUES;
import static ru.yandex.direct.core.entity.adgroupadditionaltargeting.UaTraitsConstants.OS_FAMILY_VALID_VALUES;
import static ru.yandex.direct.core.entity.adgroupadditionaltargeting.UaTraitsConstants.OS_NAME_VALID_VALUES;

@Service
@ParametersAreNonnullByDefault
public class AdGroupAdditionalTargetingTypeSpecificValidationProvider {
    private final Map<Class<? extends AdGroupAdditionalTargeting>,
            AdGroupAdditionalTargetingTypeSpecificValidationService<AdGroupAdditionalTargeting>> serviceMap;

    public AdGroupAdditionalTargetingTypeSpecificValidationProvider() {

        var hasPassportIdTargetingValidation =
                new CommonSuccessfulValidation<>(HasPassportIdAdGroupAdditionalTargeting.class);

        var isVirusedTargetingValidation =
                new CommonSuccessfulValidation<>(IsVirusedAdGroupAdditionalTargeting.class);

        var hasLCookieTargetingValidation =
                new CommonSuccessfulValidation<>(HasLCookieAdGroupAdditionalTargeting.class);

        var internalNetworkTargetingValidation =
                new CommonSuccessfulValidation<>(InternalNetworkAdGroupAdditionalTargeting.class);

        var isMobileTargetingValidation =
                new CommonSuccessfulValidation<>(IsMobileAdGroupAdditionalTargeting.class);

        var isTabletTargetingValidation =
                new CommonSuccessfulValidation<>(IsTabletAdGroupAdditionalTargeting.class);

        var isTouchTargetingValidation =
                new CommonSuccessfulValidation<>(IsTouchAdGroupAdditionalTargeting.class);

        var yandexuidAgeTargetingValidation = new YandexuidAgeTargetingValidation();

        var yandexUidsTargetingValidation = new YandexUidsTargetingValidation();

        var queryReferersTargetingValidation =
                new ReferrersTargetingValidation<>(QueryReferersAdGroupAdditionalTargeting.class,
                        QueryReferersAdGroupAdditionalTargeting.VALUE);

        var callerReferrersTargetingValidation =
                new ReferrersTargetingValidation<>(CallerReferrersAdGroupAdditionalTargeting.class,
                        CallerReferrersAdGroupAdditionalTargeting.VALUE);

        var interfaceLangsTargetingValidation = new InterfaceLangsTargetingValidation();

        var userAgentsTargetingValidation =
                new CommonListOfStringsValidation<>(UserAgentsAdGroupAdditionalTargeting.class,
                        UserAgentsAdGroupAdditionalTargeting.VALUE);

        var browserEnginesTargetingValidation = new VersionedUatraitsTargetingValidation<>(
                BrowserEnginesAdGroupAdditionalTargeting.class,
                BrowserEnginesAdGroupAdditionalTargeting.VALUE,
                BROWSER_ENGINE_VALID_VALUES);

        var browserNamesTargetingValidation = new VersionedUatraitsTargetingValidation<>(
                BrowserNamesAdGroupAdditionalTargeting.class,
                BrowserNamesAdGroupAdditionalTargeting.VALUE,
                BROWSER_NAME_VALID_VALUES);

        var osFamiliesTargetingValidation = new VersionedUatraitsTargetingValidation<>(
                OsFamiliesAdGroupAdditionalTargeting.class,
                OsFamiliesAdGroupAdditionalTargeting.VALUE,
                OS_FAMILY_VALID_VALUES);

        var osNamesTargetingValidation = new CommonUatraitsTargetingValidation<>(
                OsNamesAdGroupAdditionalTargeting.class,
                OsNamesAdGroupAdditionalTargeting.VALUE,
                OS_NAME_VALID_VALUES);

        var deviceVendorsTargetingValidation = new CommonUatraitsTargetingValidation<>(
                DeviceVendorsAdGroupAdditionalTargeting.class,
                DeviceVendorsAdGroupAdditionalTargeting.VALUE,
                DEVICE_VENDOR_VALID_VALUES);

        var deviceNamesTargetingValidation = new CommonListOfStringsValidation<>(
                DeviceNamesAdGroupAdditionalTargeting.class,
                DeviceNamesAdGroupAdditionalTargeting.VALUE
        );

        var showDatesTargetingValidation = new ShowDatesTargetingValidation();

        var desktopInstalledAppsTargetingValidation = new DesktopInstalledAppsTargetingValidation();

        var clidTypesTargetingValidation = new CommonSetOfPositiveLongsValidation<>(
                ClidTypesAdGroupAdditionalTargeting.class,
                ClidTypesAdGroupAdditionalTargeting.VALUE
        );

        var clidsTargetingValidation = new CommonSetOfPositiveLongsValidation<>(
                ClidsAdGroupAdditionalTargeting.class,
                ClidsAdGroupAdditionalTargeting.VALUE
        );

        var queryOptionsTargetingValidation = new CommonSetOfStringsValidation<>(
                QueryOptionsAdGroupAdditionalTargeting.class,
                QueryOptionsAdGroupAdditionalTargeting.VALUE
        );

        var testIdsTargetingValidation = new CommonSetOfPositiveLongsValidation<>(
                TestIdsAdGroupAdditionalTargeting.class,
                TestIdsAdGroupAdditionalTargeting.VALUE
        );

        var ysCookiesTargetingValidation = new CommonSetOfStringsValidation<>(
                YsCookiesAdGroupAdditionalTargeting.class,
                YsCookiesAdGroupAdditionalTargeting.VALUE
        );

        var isYandexPlusTargetingValidation =
                new CommonSuccessfulValidation<>(IsYandexPlusAdGroupAdditionalTargeting.class);

        var isPPLoggedInTargetingValidation =
                new CommonSuccessfulValidation<>(IsPPLoggedInAdGroupAdditionalTargeting.class);

        var mobileInstalledAppsTargetingValidation = new MobileInstalledAppsTargetingValidation();

        var featuresInPPTargetingValidation = new CommonSetOfStringsValidation<>(
                FeaturesInPPAdGroupAdditionalTargeting.class,
                FeaturesInPPAdGroupAdditionalTargeting.VALUE
        );
        var ypCookiesTargetingValidation = new CommonSetOfStringsValidation<>(
                YpCookiesAdGroupAdditionalTargeting.class,
                YpCookiesAdGroupAdditionalTargeting.VALUE
        );
        var isDefaultYandexSearchTargetingValidation =
                new CommonSuccessfulValidation<>(IsDefaultYandexSearchAdGroupAdditionalTargeting.class);

        var sidsTargetingValidation = new CommonSetOfPositiveLongsValidation<>(
                SidsAdGroupAdditionalTargeting.class, SidsAdGroupAdditionalTargeting.VALUE);

        var uuidsTargetingValidation = new UuidsTargetingValidation();

        var deviceIdsTargetingValidation = new DeviceIdsTargetingValidation();

        var plusUserSegmentsTargetingValidation = new CommonSetOfPositiveLongsValidation<>(
                PlusUserSegmentsAdGroupAdditionalTargeting.class, PlusUserSegmentsAdGroupAdditionalTargeting.VALUE);

        var searchTextTargetingValidation = new CommonSetOfStringsValidation<>(
                SearchTextAdGroupAdditionalTargeting.class, SearchTextAdGroupAdditionalTargeting.VALUE);

        var auditoriumTargetingValidation = new CommonSetOfPositiveLongsValidation<>(
                AuditoriumGeoSegmentsAdGroupAdditionalTargeting.class,
                AuditoriumGeoSegmentsAdGroupAdditionalTargeting.VALUE
        );

        var contentCategoriesTargetingValidation = new ContentCategoriesTargetingValidation();

        var timeTargetingValidation = new TimeTargetingValidation();

        var services = List.of(
                upCast(hasPassportIdTargetingValidation),
                upCast(isVirusedTargetingValidation),
                upCast(hasLCookieTargetingValidation),
                upCast(internalNetworkTargetingValidation),
                upCast(isMobileTargetingValidation),
                upCast(isTabletTargetingValidation),
                upCast(isTouchTargetingValidation),
                upCast(yandexuidAgeTargetingValidation),
                upCast(yandexUidsTargetingValidation),
                upCast(queryReferersTargetingValidation),
                upCast(callerReferrersTargetingValidation),
                upCast(interfaceLangsTargetingValidation),
                upCast(userAgentsTargetingValidation),
                upCast(browserEnginesTargetingValidation),
                upCast(browserNamesTargetingValidation),
                upCast(osFamiliesTargetingValidation),
                upCast(osNamesTargetingValidation),
                upCast(deviceVendorsTargetingValidation),
                upCast(deviceNamesTargetingValidation),
                upCast(showDatesTargetingValidation),
                upCast(desktopInstalledAppsTargetingValidation),
                upCast(clidTypesTargetingValidation),
                upCast(clidsTargetingValidation),
                upCast(queryOptionsTargetingValidation),
                upCast(testIdsTargetingValidation),
                upCast(ysCookiesTargetingValidation),
                upCast(isYandexPlusTargetingValidation),
                upCast(isPPLoggedInTargetingValidation),
                upCast(mobileInstalledAppsTargetingValidation),
                upCast(featuresInPPTargetingValidation),
                upCast(ypCookiesTargetingValidation),
                upCast(isDefaultYandexSearchTargetingValidation),
                upCast(sidsTargetingValidation),
                upCast(uuidsTargetingValidation),
                upCast(deviceIdsTargetingValidation),
                upCast(plusUserSegmentsTargetingValidation),
                upCast(searchTextTargetingValidation),
                upCast(auditoriumTargetingValidation),
                upCast(contentCategoriesTargetingValidation),
                upCast(timeTargetingValidation)
        );

        this.serviceMap = services.stream()
                .collect(toMap(AdGroupAdditionalTargetingTypeSpecificValidationService::getTargetingClass, identity()));
    }

    @SuppressWarnings("unchecked")
    private static <T extends AdGroupAdditionalTargeting>
    AdGroupAdditionalTargetingTypeSpecificValidationService<AdGroupAdditionalTargeting> upCast(
            AdGroupAdditionalTargetingTypeSpecificValidationService<T> service) {
        return (AdGroupAdditionalTargetingTypeSpecificValidationService<AdGroupAdditionalTargeting>) service;
    }

    public ValidationResult<List<AdGroupAdditionalTargeting>, Defect> validateTargetings(
            List<AdGroupAdditionalTargeting> targetings) {
        ListValidationBuilder<AdGroupAdditionalTargeting, Defect> vb =
                ListValidationBuilder.of(targetings, Defect.class);

        vb.checkEachBy(targeting -> {
            AdGroupAdditionalTargetingTypeSpecificValidationService<AdGroupAdditionalTargeting> validationService =
                    serviceMap.get(targeting.getClass());
            return validationService.validateAdGroupAdditionalTargeting(targeting);
        });

        return vb.getResult();
    }
}
