package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.eachNotNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.eachNotBlank;

@ParametersAreNonnullByDefault
class CommonListOfStringsValidation<T extends AdGroupAdditionalTargeting>
        implements AdGroupAdditionalTargetingTypeSpecificValidationService<T> {
    private final Class<T> targetingClass;
    protected final ModelProperty<T, List<String>> modelProperty;

    CommonListOfStringsValidation(Class<T> targetingClass, ModelProperty<T, List<String>> modelProperty) {
        this.targetingClass = targetingClass;
        this.modelProperty = modelProperty;
    }

    @Override
    public ValidationResult<T, Defect> validateAdGroupAdditionalTargeting(T targeting) {
        ModelItemValidationBuilder<T> vb =
                ModelItemValidationBuilder.of(targeting);
        vb.list(modelProperty)
                .check(notNull())
                .check(notEmptyCollection(), When.isValid())
                .check(eachNotNull(), When.isValid())
                .check(eachNotBlank(), When.isValid());

        addCustomValidation(vb);

        return vb.getResult();
    }

    /**
     * Кастомная валидация для наследников текущего класса
     */
    protected void addCustomValidation(ModelItemValidationBuilder<T> vb) {
    }

    @Override
    public Class<T> getTargetingClass() {
        return targetingClass;
    }
}
