package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.defect.NumberDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.eachInSetNotNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
public class CommonSetOfPositiveLongsValidation<T extends AdGroupAdditionalTargeting>
        implements AdGroupAdditionalTargetingTypeSpecificValidationService<T> {
    private final Class<T> targetingClass;
    private final ModelProperty<T, Set<Long>> modelProperty;

    CommonSetOfPositiveLongsValidation(Class<T> targetingClass, ModelProperty<T, Set<Long>> modelProperty) {
        this.targetingClass = targetingClass;
        this.modelProperty = modelProperty;
    }

    @Override
    public ValidationResult<T, Defect> validateAdGroupAdditionalTargeting(T targeting) {
        ModelItemValidationBuilder<T> vb =
                ModelItemValidationBuilder.of(targeting);
        vb.item(modelProperty)
                .check(notNull())
                .check(notEmptyCollection(), When.isValid())
                .check(eachInSetNotNull(), When.isValid())
                .check(eachValuePositive(), When.isValid());
        return vb.getResult();
    }

    private Constraint<Set<Long>, Defect> eachValuePositive() {
        return Constraint.fromPredicate(list -> list.stream().allMatch(v -> v > 0L), NumberDefects.greaterThan(0L));
    }

    @Override
    public Class<T> getTargetingClass() {
        return targetingClass;
    }
}
