package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.eachInSetNotNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.eachInSetNotBlank;

@ParametersAreNonnullByDefault
public class CommonSetOfStringsValidation<T extends AdGroupAdditionalTargeting>
        implements AdGroupAdditionalTargetingTypeSpecificValidationService<T> {
    private final Class<T> targetingClass;
    private final ModelProperty<T, Set<String>> modelProperty;

    CommonSetOfStringsValidation(Class<T> targetingClass, ModelProperty<T, Set<String>> modelProperty) {
        this.targetingClass = targetingClass;
        this.modelProperty = modelProperty;
    }

    @Override
    public ValidationResult<T, Defect> validateAdGroupAdditionalTargeting(T targeting) {
        ModelItemValidationBuilder<T> vb =
                ModelItemValidationBuilder.of(targeting);
        vb.item(modelProperty)
                .check(notNull())
                .check(notEmptyCollection(), When.isValid())
                .check(eachInSetNotNull(), When.isValid())
                .check(eachInSetNotBlank(), When.isValid());
        return vb.getResult();
    }

    @Override
    public Class<T> getTargetingClass() {
        return targetingClass;
    }
}
