package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@ParametersAreNonnullByDefault
class CommonSuccessfulValidation<T extends AdGroupAdditionalTargeting>
        implements AdGroupAdditionalTargetingTypeSpecificValidationService<T> {
    private final Class<T> targetingClass;

    CommonSuccessfulValidation(Class<T> targetingClass) {
        this.targetingClass = targetingClass;
    }

    @Override
    public ValidationResult<T, Defect> validateAdGroupAdditionalTargeting(T targeting) {
        return ValidationResult.success(targeting);
    }

    @Override
    public Class<T> getTargetingClass() {
        return targetingClass;
    }
}
