package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.UatraitsTargeting;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.Predicates.each;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.eachNotNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

@ParametersAreNonnullByDefault
class CommonUatraitsTargetingValidation<T extends AdGroupAdditionalTargeting, U extends UatraitsTargeting>
        implements AdGroupAdditionalTargetingTypeSpecificValidationService<T> {
    private final Class<T> targetingClass;
    private final ModelProperty<T, List<U>> modelProperty;
    private final Set<Long> existentEntryIds;

    CommonUatraitsTargetingValidation(Class<T> targetingClass, ModelProperty<T, List<U>> modelProperty,
                                      Set<Long> existentEntryIds) {
        this.targetingClass = targetingClass;
        this.modelProperty = modelProperty;
        this.existentEntryIds = existentEntryIds;
    }

    @Override
    public ValidationResult<T, Defect> validateAdGroupAdditionalTargeting(T targeting) {
        ModelItemValidationBuilder<T> vb =
                ModelItemValidationBuilder.of(targeting);
        vb.list(modelProperty)
                .check(notNull())
                .check(notEmptyCollection(), When.isValid())
                .check(eachNotNull(), When.isValid())
                .check(eachValueHasCorrectEntryId(), When.isValid());
        return vb.getResult();
    }

    private Constraint<List<U>, Defect> eachValueHasCorrectEntryId() {
        return Constraint.fromPredicate(each(v -> existentEntryIds.contains(v.getTargetingValueEntryId())),
                invalidValue());
    }

    @Override
    public Class<T> getTargetingClass() {
        return targetingClass;
    }
}
