package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargetingJoinType;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargetingMode;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ContentCategoriesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.adgroup.service.validation.ContentCategoriesRetargetingConditionRulesValidator.ALLOWED_GOAL_TYPES;
import static ru.yandex.direct.core.entity.retargeting.Constants.MAX_GOALS_PER_RULE;
import static ru.yandex.direct.core.entity.retargeting.Constants.MIN_GOALS_PER_RULE;
import static ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefects.unsupportedGoalId;
import static ru.yandex.direct.validation.Predicates.each;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.setSize;
import static ru.yandex.direct.validation.constraint.CommonConstraints.eachInSetNotNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.isEqual;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

@Component
@ParametersAreNonnullByDefault
public class ContentCategoriesTargetingValidation
        implements AdGroupAdditionalTargetingTypeSpecificValidationService<ContentCategoriesAdGroupAdditionalTargeting> {

    @Override
    public ValidationResult<ContentCategoriesAdGroupAdditionalTargeting, Defect> validateAdGroupAdditionalTargeting(
            ContentCategoriesAdGroupAdditionalTargeting targeting) {
        ModelItemValidationBuilder<ContentCategoriesAdGroupAdditionalTargeting> vb =
                ModelItemValidationBuilder.of(targeting);
        // пока разрешаем только позитивные условия таргетинга по "или"
        vb.item(ContentCategoriesAdGroupAdditionalTargeting.JOIN_TYPE)
                .check(isEqual(AdGroupAdditionalTargetingJoinType.ANY, invalidValue()));
        vb.item(ContentCategoriesAdGroupAdditionalTargeting.TARGETING_MODE)
                .check(isEqual(AdGroupAdditionalTargetingMode.TARGETING, invalidValue()));
        vb.item(ContentCategoriesAdGroupAdditionalTargeting.VALUE)
                .check(notNull())
                .check(setSize(MIN_GOALS_PER_RULE, MAX_GOALS_PER_RULE), When.isValid())
                .check(eachInSetNotNull(), When.isValid())
                .check(eachValueIsCorrect(), When.isValid());
        return vb.getResult();
    }

    private Constraint<Set<Long>, Defect> eachValueIsCorrect() {
        return Constraint.fromPredicate(
                each(goalId -> ALLOWED_GOAL_TYPES.contains(Goal.computeType(goalId))),
                unsupportedGoalId());
    }

    @Override
    public Class<ContentCategoriesAdGroupAdditionalTargeting> getTargetingClass() {
        return ContentCategoriesAdGroupAdditionalTargeting.class;
    }
}
