package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.DesktopInstalledAppsAdGroupAdditionalTargeting;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.adgroupadditionaltargeting.DistribSoftConstants.DISTRIB_PRODUCT_VALID_VALUES;
import static ru.yandex.direct.validation.Predicates.each;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.eachInSetNotNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

@ParametersAreNonnullByDefault
public class DesktopInstalledAppsTargetingValidation
        implements AdGroupAdditionalTargetingTypeSpecificValidationService<DesktopInstalledAppsAdGroupAdditionalTargeting> {

    @Override
    public ValidationResult<DesktopInstalledAppsAdGroupAdditionalTargeting, Defect> validateAdGroupAdditionalTargeting(
            DesktopInstalledAppsAdGroupAdditionalTargeting targeting) {
        ModelItemValidationBuilder<DesktopInstalledAppsAdGroupAdditionalTargeting> vb =
                ModelItemValidationBuilder.of(targeting);
        vb.item(DesktopInstalledAppsAdGroupAdditionalTargeting.VALUE)
                .check(notNull())
                .check(notEmptyCollection(), When.isValid())
                .check(eachInSetNotNull(), When.isValid())
                .check(eachValueIsCorrect(), When.isValid());
        return vb.getResult();
    }

    private Constraint<Set<Long>, Defect> eachValueIsCorrect() {
        return Constraint.fromPredicate(each(DISTRIB_PRODUCT_VALID_VALUES::contains),
                invalidValue());
    }

    @Override
    public Class<DesktopInstalledAppsAdGroupAdditionalTargeting> getTargetingClass() {
        return DesktopInstalledAppsAdGroupAdditionalTargeting.class;
    }
}
