package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InterfaceLangsAdGroupAdditionalTargeting;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
class InterfaceLangsTargetingValidation
        implements AdGroupAdditionalTargetingTypeSpecificValidationService<InterfaceLangsAdGroupAdditionalTargeting> {
    @Override
    public ValidationResult<InterfaceLangsAdGroupAdditionalTargeting, Defect> validateAdGroupAdditionalTargeting(
            InterfaceLangsAdGroupAdditionalTargeting targeting) {
        ModelItemValidationBuilder<InterfaceLangsAdGroupAdditionalTargeting> vb =
                ModelItemValidationBuilder.of(targeting);
        vb.item(InterfaceLangsAdGroupAdditionalTargeting.VALUE)
                .check(notNull())
                .check(notEmptyCollection(), When.isValid());
        return vb.getResult();
    }

    @Override
    public Class<InterfaceLangsAdGroupAdditionalTargeting> getTargetingClass() {
        return InterfaceLangsAdGroupAdditionalTargeting.class;
    }
}
