package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.MobileInstalledApp;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.MobileInstalledAppsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.mobilecontent.util.MobileAppStoreUrlParser;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.Predicates.each;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

@ParametersAreNonnullByDefault
public class MobileInstalledAppsTargetingValidation implements AdGroupAdditionalTargetingTypeSpecificValidationService<MobileInstalledAppsAdGroupAdditionalTargeting> {
    @Override
    public ValidationResult<MobileInstalledAppsAdGroupAdditionalTargeting, Defect> validateAdGroupAdditionalTargeting(MobileInstalledAppsAdGroupAdditionalTargeting targeting) {
        var vb = ModelItemValidationBuilder.of(targeting);

        vb.item(MobileInstalledAppsAdGroupAdditionalTargeting.VALUE)
                .check(notNull())
                .check(notEmptyCollection(), When.isValid())
                .check(eachValueIsCorrect(), When.isValid());

        return vb.getResult();
    }

    private Constraint<Set<MobileInstalledApp>, Defect> eachValueIsCorrect() {
        return Constraint.fromPredicate(each(
                app -> MobileAppStoreUrlParser.parse(app.getStoreUrl()).isPresent()), invalidValue());
    }

    @Override
    public Class<MobileInstalledAppsAdGroupAdditionalTargeting> getTargetingClass() {
        return MobileInstalledAppsAdGroupAdditionalTargeting.class;
    }
}
