package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.defect.CommonDefects.invalidFormat;

@ParametersAreNonnullByDefault
public class ReferrersTargetingValidation<T extends AdGroupAdditionalTargeting> extends CommonListOfStringsValidation<T> {

    ReferrersTargetingValidation(Class<T> targetingClass, ModelProperty<T, List<String>> modelProperty) {
        super(targetingClass, modelProperty);
    }

    @Override
    protected void addCustomValidation(ModelItemValidationBuilder<T> vb) {
        vb.list(modelProperty)
                .checkEach(notSinglePercent(), When.isValid());
    }

    private Constraint<String, Defect> notSinglePercent() {
        return Constraint.fromPredicate(v -> !v.trim().chars().allMatch(e -> e == '%'), invalidFormat());
    }
}
