package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ShowDatesAdGroupAdditionalTargeting;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.eachInSetNotNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
public class ShowDatesTargetingValidation implements AdGroupAdditionalTargetingTypeSpecificValidationService<ShowDatesAdGroupAdditionalTargeting> {
    @Override
    public ValidationResult<ShowDatesAdGroupAdditionalTargeting, Defect> validateAdGroupAdditionalTargeting(
            ShowDatesAdGroupAdditionalTargeting targeting) {
        ModelItemValidationBuilder<ShowDatesAdGroupAdditionalTargeting> vb = ModelItemValidationBuilder.of(targeting);
        vb.item(ShowDatesAdGroupAdditionalTargeting.VALUE)
                .check(notNull())
                .check(notEmptyCollection(), When.isValid())
                .check(eachInSetNotNull(), When.isValid());
        return vb.getResult();
    }

    @Override
    public Class<ShowDatesAdGroupAdditionalTargeting> getTargetingClass() {
        return ShowDatesAdGroupAdditionalTargeting.class;
    }
}
