package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.logging.log4j.util.Strings;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UuidsAdGroupAdditionalTargeting;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.eachInSetNotNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
public class UuidsTargetingValidation
        implements AdGroupAdditionalTargetingTypeSpecificValidationService<UuidsAdGroupAdditionalTargeting> {
    @Override
    public ValidationResult<UuidsAdGroupAdditionalTargeting, Defect> validateAdGroupAdditionalTargeting(
            UuidsAdGroupAdditionalTargeting targeting) {
        var vb = ModelItemValidationBuilder.of(targeting);
        vb.item(UuidsAdGroupAdditionalTargeting.VALUE)
                .check(notNull())
                .check(notEmptyCollection(), When.isValid())
                .check(eachInSetNotNull(), When.isValid())
                .check(eachValueIsCorrect(), When.isValid());
        return vb.getResult();
    }

    private Constraint<Set<String>, Defect> eachValueIsCorrect() {
        return Constraint.fromPredicate(
                list -> list.stream().allMatch(
                        value -> Strings.isNotBlank(value) && !value.contains(",") && !value.contains(" ")),
                CommonDefects.invalidValue());
    }

    @Override
    public Class<UuidsAdGroupAdditionalTargeting> getTargetingClass() {
        return UuidsAdGroupAdditionalTargeting.class;
    }
}
