package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types;

import java.util.List;
import java.util.regex.Pattern;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexUidsAdGroupAdditionalTargeting;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.Predicates.each;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.eachNotNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

@ParametersAreNonnullByDefault
class YandexUidsTargetingValidation
        implements AdGroupAdditionalTargetingTypeSpecificValidationService<YandexUidsAdGroupAdditionalTargeting> {
    private static final Pattern YANDEXUID_PATTERN = Pattern.compile("^[1-9][0-9]{16,18}$|^%[0-9]{1,2}$");

    @Override
    public ValidationResult<YandexUidsAdGroupAdditionalTargeting, Defect> validateAdGroupAdditionalTargeting(
            YandexUidsAdGroupAdditionalTargeting targeting) {
        ModelItemValidationBuilder<YandexUidsAdGroupAdditionalTargeting> vb =
                ModelItemValidationBuilder.of(targeting);
        vb.list(YandexUidsAdGroupAdditionalTargeting.VALUE)
                .check(notNull())
                .check(notEmptyCollection(), When.isValid())
                .check(eachNotNull(), When.isValid())
                .check(eachYaUidCorrect(), When.isValid());
        return vb.getResult();
    }

    private Constraint<List<String>, Defect> eachYaUidCorrect() {
        return Constraint.fromPredicate(each(v -> YANDEXUID_PATTERN.matcher(v).matches()), invalidValue());
    }

    @Override
    public Class<YandexUidsAdGroupAdditionalTargeting> getTargetingClass() {
        return YandexUidsAdGroupAdditionalTargeting.class;
    }
}
