package ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdditionalTargetingValue
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexuidAgeAdGroupAdditionalTargeting
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.types.YandexuidAgeTargetingValidation.Companion.MIN_AGE_VALUE
import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.builder.Constraint.fromPredicate
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.defect.NumberDefects.greaterThanOrEqualTo
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

class YandexuidAgeTargetingValidation
    : AdGroupAdditionalTargetingTypeSpecificValidationService<YandexuidAgeAdGroupAdditionalTargeting> {

    companion object {
        const val MIN_AGE_VALUE = 0
    }

    override fun validateAdGroupAdditionalTargeting(targeting: YandexuidAgeAdGroupAdditionalTargeting)
            : ValidationResult<YandexuidAgeAdGroupAdditionalTargeting, Defect<Any>> {
        val vb = ModelItemValidationBuilder.of<YandexuidAgeAdGroupAdditionalTargeting>(targeting)

        vb.item(YandexuidAgeAdGroupAdditionalTargeting.VALUE)
            .check(CommonConstraints.notNull())
            .check(valueNotLessMin(), When.isValid())
        return vb.result
    }

    override fun getTargetingClass(): Class<YandexuidAgeAdGroupAdditionalTargeting> {
        return YandexuidAgeAdGroupAdditionalTargeting::class.java
    }
}

private fun valueNotLessMin(): Constraint<AdditionalTargetingValue<Int>, Defect<*>?> {
    return fromPredicate({ it.value != null && it.value >= MIN_AGE_VALUE }, greaterThanOrEqualTo(MIN_AGE_VALUE))
}
