package ru.yandex.direct.core.entity.agencyofflinereport.container;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Описывает результат выполнения задачи на построение отчета
 */
public class AgencyOfflineReportBuilderJobResult {

    private final String reportUrl;
    private final String error;

    @JsonCreator
    public AgencyOfflineReportBuilderJobResult(@JsonProperty("reportUrl") String reportUrl,
                                               @JsonProperty("error") String error) {
        this.reportUrl = reportUrl;
        this.error = error;
    }

    public static AgencyOfflineReportBuilderJobResult error(String stacktrace) {
        return new AgencyOfflineReportBuilderJobResult(null, stacktrace);
    }

    public static AgencyOfflineReportBuilderJobResult success(String reportUrl) {
        return new AgencyOfflineReportBuilderJobResult(reportUrl, null);
    }

    @SuppressWarnings("unused")
    public String getReportUrl() {
        return reportUrl;
    }

    @SuppressWarnings("unused")
    public String getError() {
        return error;
    }
}
