package ru.yandex.direct.core.entity.agencyofflinereport.container;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.agencyofflinereport.model.AgencyOfflineReport;
import ru.yandex.direct.core.entity.agencyofflinereport.model.AgencyOfflineReportKind;
import ru.yandex.direct.dbutil.model.ClientId;

/**
 * Параметры оффлайн-отчеты, хранящиеся и передаваемый в задачу на его построение.
 */
public class AgencyOfflineReportJobParams {
    @JsonProperty
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private LocalDate dateFrom;

    @JsonProperty
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private LocalDate dateTo;

    @JsonProperty
    private Long reportId;

    @JsonProperty
    private ClientId agencyClientId;

    @JsonProperty
    private String agencyLogin;

    @JsonProperty
    private AgencyOfflineReportKind reportKind;

    @JsonProperty
    private List<ClientId> subclients;

    public AgencyOfflineReportJobParams(AgencyOfflineReport report) {
        this.subclients = new ArrayList<>();

        this.reportId = report.getReportId();

        AgencyOfflineReportArgs args = report.getArgs();
        this.dateFrom = args.getDateFrom();
        this.dateTo = args.getDateTo();
        this.agencyClientId = report.getAgencyClientId();
        this.agencyLogin = args.getAgencyLogin();
        this.reportKind = args.getReportKind();
    }

    @SuppressWarnings("unused") // используется при инстанциировании модели из json-представления
    public AgencyOfflineReportJobParams() {
    }

    public AgencyOfflineReportJobParams withSubclients(List<ClientId> subclients) {
        this.subclients = subclients;
        return this;
    }

    public LocalDate getDateFrom() {
        return dateFrom;
    }

    public LocalDate getDateTo() {
        return dateTo;
    }

    public Long getReportId() {
        return reportId;
    }

    public ClientId getAgencyClientId() {
        return agencyClientId;
    }

    public String getAgencyLogin() {
        return agencyLogin;
    }

    public AgencyOfflineReportKind getReportKind() {
        return reportKind;
    }

    public List<ClientId> getSubclients() {
        return subclients;
    }

}
