package ru.yandex.direct.core.entity.api.application.repository;

import java.util.Collection;
import java.util.Map;

import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbschema.ppcdict.tables.ApiAppCertificationRequest;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static java.util.Collections.emptyMap;
import static ru.yandex.direct.dbschema.ppcdict.tables.ApiAppCertificationRequest.API_APP_CERTIFICATION_REQUEST;

@Component
public class ApiApplicationCertificationRequestRepository {
    private final DslContextProvider dslContextProvider;

    @Autowired
    public ApiApplicationCertificationRequestRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * По набору application_id получить названия приложений (как они сохранены в api_app_certification_request).
     * Выбирается "максимальное" название, хотя они все должны быть равны.
     * Если приложения в базе нет - ключ не возвращается.
     */
    public Map<String, String> getApplicationsNames(Collection<String> ids) {
        if (ids.isEmpty()) {
            return emptyMap();
        }
        ApiAppCertificationRequest tbl = API_APP_CERTIFICATION_REQUEST.as("ar");
        return dslContextProvider.ppcdict()
                .select(tbl.APPLICATION_ID, DSL.max(tbl.NAME).as(tbl.NAME))
                .from(tbl)
                .where(tbl.APPLICATION_ID.in(ids))
                .groupBy(tbl.APPLICATION_ID)
                .fetchMap(tbl.APPLICATION_ID, tbl.NAME);
    }
}
