package ru.yandex.direct.core.entity.application.repository;

import org.jooq.Record1;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.application.model.AccessType;
import ru.yandex.direct.dbschema.ppcdict.enums.ApiAppAccessAccessType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppcdict.tables.ApiAppAccess.API_APP_ACCESS;

/**
 * Repository for working with ppcdict.api_app_access table
 */
@Repository
public class ApiAppAccessRepository {

    @Autowired
    DslContextProvider dslContextProvider;

    public AccessType getAccessType(String applicationId) {
        Record1<ApiAppAccessAccessType> record = dslContextProvider.ppcdict()
                .select(API_APP_ACCESS.ACCESS_TYPE)
                .from(API_APP_ACCESS)
                .where(API_APP_ACCESS.APPLICATION_ID.eq(applicationId))
                .fetchOne();
        return record == null ? null : convertAccessType(record.value1());
    }

    private AccessType convertAccessType(ApiAppAccessAccessType dbAccessType) {
        if (dbAccessType == null) {
            return null;
        }
        switch (dbAccessType) {
            case test:
                return AccessType.TEST;
            case normal:
                return AccessType.NORMAL;
            case advanced:
                return AccessType.ADVANCED;
            default:
                return null;
        }
    }

}
