package ru.yandex.direct.core.entity.application.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.application.model.AccessType;
import ru.yandex.direct.core.entity.application.repository.ApiAppAccessRepository;
import ru.yandex.direct.env.EnvironmentType;

/**
 * Methods for working with data for third-party applications
 */
@Service
public class ApiAppAccessService {

    private final ApiAppAccessRepository apiAppAccessRepository;
    private final EnvironmentType environmentType;

    @Autowired
    public ApiAppAccessService(ApiAppAccessRepository apiAppAccessRepository, EnvironmentType environmentType) {
        this.apiAppAccessRepository = apiAppAccessRepository;
        this.environmentType = environmentType;
    }

    /**
     * Checks whether third-party application with specified "application_id"
     * has access to Direct API.
     *
     * @param applicationId application_id (returned by Blackbox oauth-method)
     * @return {@code true} if application has access to Direct API, {@code false} otherwise.
     */
    public boolean checkApplicationAccess(String applicationId) {
        AccessType accessType = apiAppAccessRepository.getAccessType(applicationId);

        if (accessType == null) {
            return false;
        }
        switch (accessType) {
            case NORMAL:
                return true;
            case TEST:
                return environmentType.isSandbox();
            default:
                return false;
        }
    }
}
