package ru.yandex.direct.core.entity.auction;

import ru.yandex.direct.core.entity.auction.container.AdGroupForAuction;
import ru.yandex.direct.core.entity.banner.model.BannerWithHref;
import ru.yandex.direct.core.entity.banner.model.McBanner;
import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.core.entity.banner.service.BannerUtils.getValueIfAssignable;

/**
 * Дополнительные данные о запросе в торги.
 */
public class BsRequestPhraseWrapperAdditionalData {

    private AdGroupForAuction adGroupForAuction;
    private Keyword keyword;

    private final String bannerDomain;
    private final boolean isMcBanner;
    private final Currency currency;
    private final String phrase;

    /**
     * Для запросов в торги по сырым ключевым фразам, которых нет в базе
     */
    public BsRequestPhraseWrapperAdditionalData(String bannerDomain, boolean isMcBanner, Currency currency, String phrase) {
        this.bannerDomain = bannerDomain;
        this.isMcBanner = isMcBanner;
        this.currency = currency;
        this.phrase = phrase;
    }

    /**
     * Для запросов в торги по ключевым фразам, которые есть в базе
     */
    public BsRequestPhraseWrapperAdditionalData(AdGroupForAuction adGroupForAuction, Keyword keyword) {
        var banner = adGroupForAuction.getBanner();

        this.bannerDomain = banner != null ? getValueIfAssignable(banner, BannerWithHref.DOMAIN) : null;
        this.isMcBanner = banner != null && banner instanceof McBanner;
        this.currency = adGroupForAuction.getCurrency();
        this.phrase = keyword.getPhrase();

        this.adGroupForAuction = adGroupForAuction;
        this.keyword = keyword;
    }

    public String getBannerDomain() {
        return bannerDomain;
    }

    public boolean isMcBanner() {
        return isMcBanner;
    }

    public Currency getCurrency() {
        return currency;
    }

    public String getPhrase() {
        return phrase;
    }

    public AdGroupForAuction getAdGroupForAuction() {
        return adGroupForAuction;
    }

    public Keyword getKeyword() {
        return keyword;
    }
}
