package ru.yandex.direct.core.entity.auction.container;

import ru.yandex.direct.bsauction.BsRequestPhrase;
import ru.yandex.direct.core.entity.auction.BsRequestPhraseWrapperAdditionalData;
import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.currency.Currency;

/**
 * Обёртка над {@link BsRequestPhrase}, которая позволяет добавить к запросу информацию о внутреннем ID фразы.
 * Это удобно при разборе ответа.
 */
public class BsRequestPhraseWrapper implements BsRequestPhrase {

    private final BsRequestPhrase origin;
    private BsRequestPhraseWrapperAdditionalData additionalData;

    public BsRequestPhraseWrapper(BsRequestPhrase origin) {
        this.origin = origin;
    }

    @Override
    public String getQueryStringValue(int id, long orderId) {
        return origin.getQueryStringValue(id, orderId);
    }

    public BsRequestPhraseWrapper withAdditionalData(BsRequestPhraseWrapperAdditionalData additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public String getBannerDomain() {
        return additionalData.getBannerDomain();
    }

    public boolean isMcBanner() {
        return additionalData.isMcBanner();
    }

    public Currency getCurrency() {
        return additionalData.getCurrency();
    }

    public String getPhrase() {
        return additionalData.getPhrase();
    }

    public Keyword getKeyword() {
        return additionalData.getKeyword();
    }

    public AdGroupForAuction getAdGroupForAuction() {
        return additionalData.getAdGroupForAuction();
    }
}
