package ru.yandex.direct.core.entity.auction.container.bs;

import java.util.Iterator;
import java.util.List;

import com.google.common.collect.Ordering;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkElementIndex;
import static java.util.Collections.unmodifiableList;

/**
 * Описание блока (Спец-размещение или Гарантия)
 */
public class Block {
    private final List<Position> positions;

    public Block(List<Position> positions) {
        checkArgument(!positions.isEmpty(), "Block can't be empty");
        checkArgument(Ordering.natural().isOrdered(positions), "Positions in block should be ordered");
        this.positions = unmodifiableList(positions);
    }

    @Deprecated
    public List<Position> getPositions() {
        return positions;
    }

    public Iterator<Position> allPositions() {
        return positions.iterator();
    }

    /**
     * @param index индекс позиции на отрезке {@code [-size; size-1]}.
     *              Отрицательные значения &ndash; позиции относительно хвоста
     * @return {@link Position} описание ставки на соответствующей позиции
     */
    public Position get(int index) {
        if (index < 0) {
            index += positions.size();
        }
        index = checkElementIndex(index, positions.size());
        return positions.get(index);
    }

    /**
     * @return {@link Position} &ndash; первая позиция в блоке
     */
    public Position first() {
        return get(0);
    }

    /**
     * @return {@link Position} &ndash; вход в блок
     */
    public Position last() {
        return get(-1);
    }

    /**
     * @return размер блока
     */
    public int size() {
        return positions.size();
    }
}
