package ru.yandex.direct.core.entity.auction.container.bs;

import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.currency.Money;

@SuppressWarnings("WeakerAccess,unused")
public class KeywordBidBsAuctionData implements BsDataWithKeyword {

    private Keyword keyword;
    private Boolean contextStopFlag;
    private Money minPrice;
    private Money broker;
    private Block premium;
    private Block guarantee;

    public Keyword getKeyword() {
        return keyword;
    }

    public KeywordBidBsAuctionData withKeyword(Keyword keyword) {
        this.keyword = keyword;
        return this;
    }

    public Boolean getContextStopFlag() {
        return contextStopFlag;
    }

    public KeywordBidBsAuctionData withContextStopFlag(
            @SuppressWarnings("SameParameterValue") Boolean contextStopFlag) {
        setContextStopFlag(contextStopFlag);
        return this;
    }

    public void setContextStopFlag(Boolean contextStopFlag) {
        this.contextStopFlag = contextStopFlag;
    }

    public Money getMinPrice() {
        return minPrice;
    }

    public KeywordBidBsAuctionData withMinPrice(Money minPrice) {
        setMinPrice(minPrice);
        return this;
    }

    public void setMinPrice(Money minPrice) {
        this.minPrice = minPrice;
    }

    public Money getBroker() {
        return broker;
    }

    public KeywordBidBsAuctionData withBroker(Money broker) {
        setBroker(broker);
        return this;
    }

    public void setBroker(Money broker) {
        this.broker = broker;
    }

    public Block getPremium() {
        return premium;
    }

    public KeywordBidBsAuctionData withPremium(Block premium) {
        setPremium(premium);
        return this;
    }

    public void setPremium(Block premium) {
        this.premium = premium;
    }

    public Block getGuarantee() {
        return guarantee;
    }

    public KeywordBidBsAuctionData withGuarantee(Block guarantee) {
        setGuarantee(guarantee);
        return this;
    }

    public void setGuarantee(Block guarantee) {
        this.guarantee = guarantee;
    }

}
