package ru.yandex.direct.core.entity.auction.container.bs;

import java.util.List;

import ru.yandex.direct.core.entity.keyword.model.Keyword;

public class KeywordTrafaretData implements BsDataWithKeyword {
    // Если данные из торгов запрашивались по keywordId, то будет заполнено поле keyword, если же по самой фразе,
    // то будет заполнено поле phrase
    private Keyword keyword;
    private String phrase;

    private List<TrafaretBidItem> bidItems;

    public Keyword getKeyword() {
        return keyword;
    }

    public KeywordTrafaretData withKeyword(Keyword keyword) {
        this.keyword = keyword;
        return this;
    }

    public List<TrafaretBidItem> getBidItems() {
        return bidItems;
    }

    public KeywordTrafaretData withBidItems(List<TrafaretBidItem> bidItems) {
        this.bidItems = bidItems;
        return this;
    }

    public String getPhrase() {
        return phrase;
    }

    public KeywordTrafaretData withPhrase(String phrase) {
        this.phrase = phrase;
        return this;
    }
}
