package ru.yandex.direct.core.entity.auction.container.bs;

import java.util.Comparator;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.currency.Money;

/**
 * Описывает место в блоке. Описание состоит из двух параметров: цены попадания на позицию и цены клика
 */
@ParametersAreNonnullByDefault
public class Position implements Comparable<Position> {
    private static final Comparator<Position> POSITION_COMPARATOR =
            Comparator.comparing(Position::getBidPrice).reversed();

    private final Money amnestyPrice;
    private final Money bidPrice;

    public Position(Money amnestyPrice, Money bidPrice) {
        this.amnestyPrice = amnestyPrice;
        this.bidPrice = bidPrice;
    }

    /**
     * цена клика
     */
    public Money getAmnestyPrice() {
        return amnestyPrice;
    }

    /**
     * ставка, чтобы попасть на позицию
     */
    public Money getBidPrice() {
        return bidPrice;
    }

    @Override
    public int compareTo(Position other) {
        return POSITION_COMPARATOR.compare(this, other);
    }
}
