package ru.yandex.direct.core.entity.auction.container.bs;

import ru.yandex.direct.currency.Money;

public class TrafaretBidItem {

    private long positionCtrCorrection;
    private Money bid;
    private Money price;

    /**
     * Возвращает значение PositionCtrCorrection в микродолях.
     * Используемый диапазон значений: (50_000, 1_110_000).
     * Пример для 1СР: 1_000_000
     */
    public long getPositionCtrCorrection() {
        return positionCtrCorrection;
    }

    public TrafaretBidItem withPositionCtrCorrection(long positionCtrCorrection) {
        this.positionCtrCorrection = positionCtrCorrection;
        return this;
    }

    public Money getBid() {
        return bid;
    }

    public TrafaretBidItem withBid(Money bid) {
        this.bid = bid;
        return this;
    }

    public Money getPrice() {
        return price;
    }

    public TrafaretBidItem withPrice(Money price) {
        this.price = price;
        return this;
    }

    @Override
    public String toString() {
        return "TrafaretBidItem{" +
                "positionCtrCorrection=" + positionCtrCorrection +
                ", bid=" + bid +
                ", price=" + price +
                '}';
    }
}
