package ru.yandex.direct.core.entity.auction.type;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.bsauction.BsRequest;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.auction.container.BsRequestPhraseWrapper;
import ru.yandex.direct.core.entity.campaign.model.Campaign;

@Component
@ParametersAreNonnullByDefault
public class BsAuctionRequestTypeSupportFacade {

    private final Map<AdGroupType, BsAuctionRequestTypeSupport> typeSupportByContentPromotionType;

    @Autowired
    public BsAuctionRequestTypeSupportFacade(List<BsAuctionRequestTypeSupport> typeSupports) {
        this.typeSupportByContentPromotionType = ImmutableMap.copyOf(
                Maps.uniqueIndex(typeSupports, BsAuctionRequestTypeSupport::getAdGroupType));
    }

    public void setAdditionalQueryParams(BsRequest<BsRequestPhraseWrapper> request, AdGroup adGroup,
                                         Campaign campaign) {
        typeSupportByContentPromotionType.getOrDefault(adGroup.getType(),
                typeSupportByContentPromotionType.get(AdGroupType.BASE)).setAdditionalQueryParams(request, adGroup, campaign);
    }
}
