package ru.yandex.direct.core.entity.auction.type.support;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.bsauction.BsRequest;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdGroup;
import ru.yandex.direct.core.entity.auction.container.BsRequestPhraseWrapper;
import ru.yandex.direct.core.entity.auction.type.BsAuctionRequestTypeSupport;
import ru.yandex.direct.core.entity.campaign.model.Campaign;

import static ru.yandex.direct.core.entity.adgroup.model.AdGroupType.CONTENT_PROMOTION;
import static ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType.VIDEO;

@Component
@ParametersAreNonnullByDefault
public class ContentPromotionBsAuctionRequestTypeSupport implements BsAuctionRequestTypeSupport {

    // https://st.yandex-team.ru/BSSERVER-9994#5d9b3b64a2b79e001d88f6a3
    private static final int PAGE_ID = 449809;
    private static final int MAIN_CTR_PREDICTION_ID = 10335;

    @Override
    public AdGroupType getAdGroupType() {
        return CONTENT_PROMOTION;
    }

    @Override
    public void setAdditionalQueryParams(BsRequest<BsRequestPhraseWrapper> request, AdGroup adGroup,
                                         Campaign campaign) {
        ContentPromotionAdGroup contentPromotionAdGroup = (ContentPromotionAdGroup) adGroup;

        if (contentPromotionAdGroup.getContentPromotionType() == VIDEO) {
            request.withPageId(PAGE_ID);
            request.withMainCtrPredictionId(MAIN_CTR_PREDICTION_ID);
        }
    }
}
