package ru.yandex.direct.core.entity.auction.type.support;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.bsauction.BsRequest;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.auction.container.BsRequestPhraseWrapper;
import ru.yandex.direct.core.entity.auction.type.BsAuctionRequestTypeSupport;
import ru.yandex.direct.core.entity.campaign.model.Campaign;

import static ru.yandex.direct.core.entity.adgroup.model.AdGroupType.MCBANNER;
import static ru.yandex.direct.core.entity.banner.type.body.BannerWithBodyConstants.MC_BANNER_BODY;
import static ru.yandex.direct.core.entity.banner.type.title.BannerConstantsService.MC_BANNER_TITLE;

@Component
@ParametersAreNonnullByDefault
public class McBannerBsAuctionRequestTypeSupport implements BsAuctionRequestTypeSupport {

    @Override
    public AdGroupType getAdGroupType() {
        return MCBANNER;
    }

    @Override
    public void setAdditionalQueryParams(BsRequest<BsRequestPhraseWrapper> request, AdGroup adGroup,
                                         Campaign campaign) {
        request.withMcBanner(true);
        request.withBannerBody(MC_BANNER_BODY);
        request.withBannerHead(MC_BANNER_TITLE);
    }
}
