package ru.yandex.direct.core.entity.auction.type.support;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.bsauction.BsRequest;
import ru.yandex.direct.bsauction.BsTargetDetailedDeviceType;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.MobileContentAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.MobileContentAdGroupDeviceTypeTargeting;
import ru.yandex.direct.core.entity.auction.container.BsRequestPhraseWrapper;
import ru.yandex.direct.core.entity.auction.type.BsAuctionRequestTypeSupport;
import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.mobilecontent.model.OsType;

import static ru.yandex.direct.core.entity.adgroup.model.AdGroupType.MOBILE_CONTENT;

@Component
@ParametersAreNonnullByDefault
public class MobileContentBsAuctionRequestTypeSupport implements BsAuctionRequestTypeSupport {

    @Override
    public AdGroupType getAdGroupType() {
        return MOBILE_CONTENT;
    }

    @Override
    public void setAdditionalQueryParams(BsRequest<BsRequestPhraseWrapper> request, AdGroup adGroup,
                                         Campaign campaign)
    {
        MobileContentAdGroup mobileAdGroup = (MobileContentAdGroup) adGroup;

        if (mobileAdGroup.getDeviceTypeTargeting().contains(MobileContentAdGroupDeviceTypeTargeting.PHONE)) {
            request.withTargetDevicePhone(true);
        }

        if (mobileAdGroup.getDeviceTypeTargeting().contains(MobileContentAdGroupDeviceTypeTargeting.TABLET)) {
            request.withTargetDeviceTablet(true);
        }

        if (mobileAdGroup.getMobileContent().getOsType() == OsType.ANDROID) {
            request.withTargetDetailedDeviceType(BsTargetDetailedDeviceType.ANDROID);
        }

        if (mobileAdGroup.getMobileContent().getOsType() == OsType.IOS) {
            request.withTargetDetailedDeviceType(BsTargetDetailedDeviceType.IOS);
        }

        request.withOnlyMobilePages(true);
    }
}
