package ru.yandex.direct.core.entity.auction.type.support;

import java.util.EnumSet;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.bsauction.BsRequest;
import ru.yandex.direct.bsauction.BsTargetDetailedDeviceType;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.auction.container.BsRequestPhraseWrapper;
import ru.yandex.direct.core.entity.auction.type.BsAuctionRequestTypeSupport;
import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignDeviceTargeting;

import static ru.yandex.direct.core.entity.adgroup.model.AdGroupType.BASE;

@Component
@ParametersAreNonnullByDefault
public class TextBsAuctionRequestTypeSupport implements BsAuctionRequestTypeSupport {

    @Override
    public AdGroupType getAdGroupType() {
        return BASE;
    }

    @Override
    public void setAdditionalQueryParams(BsRequest<BsRequestPhraseWrapper> request, AdGroup adGroup,
                                         Campaign campaign) {
        if (campaign.getDeviceTargeting().isEmpty()) {
            return;
        }

        boolean isIOS = false;
        boolean isAndroid = false;
        EnumSet<CampaignDeviceTargeting> deviceTargeting = campaign.getDeviceTargeting();

        if (deviceTargeting.contains(CampaignDeviceTargeting.IPHONE)) {
            isIOS = true;
            request.withTargetDevicePhone(true);
        }

        if (deviceTargeting.contains(CampaignDeviceTargeting.IPAD)) {
            isIOS = true;
            request.withTargetDeviceTablet(true);
        }

        if (deviceTargeting.contains(CampaignDeviceTargeting.ANDROID_PHONE)) {
            isAndroid = true;
            request.withTargetDevicePhone(true);
        }

        if (deviceTargeting.contains(CampaignDeviceTargeting.ANDROID_TABLET)) {
            isAndroid = true;
            request.withTargetDeviceTablet(true);
        }

        if (deviceTargeting.contains(CampaignDeviceTargeting.OTHER_DEVICES)) {
            isIOS = false;
            isAndroid = false;
            request.withTargetDeviceDesktop(true);
        }

        if (isIOS && !isAndroid) {
            request.withTargetDetailedDeviceType(BsTargetDetailedDeviceType.IOS);
        }

        if (isAndroid && !isIOS) {
            request.withTargetDetailedDeviceType(BsTargetDetailedDeviceType.ANDROID);
        }
    }
}
