package ru.yandex.direct.core.entity.auction.utils;

import java.math.BigInteger;

import javax.annotation.Nullable;

import com.google.common.base.CharMatcher;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.utils.text.StringModifier;

import static ru.yandex.direct.core.entity.banner.service.validation.BannerLettersConstants.TEMPLATE_LABEL_RE;

/**
 * Набор утилитных методов для обработки объектов для Торгов и Показометра
 */
public class BsAuctionUtils {
    private static final String TEMPLATE_TEXT_REPLACEMENT = "TMPLPHRASE";

    private static final StringModifier CLEAN_BANNER_MODIFIER = new StringModifier.Builder()
            .withCustomRule(StringUtils::normalizeSpace)
            .withRegexpReplaceAllRule(TEMPLATE_LABEL_RE, TEMPLATE_TEXT_REPLACEMENT)
            .build();

    // protected/BSAuction.pm:_prepare_text
    private static final StringModifier KEYWORD_MODIFIER = new StringModifier.Builder()
            .withRemoveAnyOf("!+")
            .withCollapseAnyOf("\r\n\"", ' ')
            .withRegexpReplaceAllRule("\\s-.*", "") // удаляем минус-слова
            .withCharMatcherCollapse(CharMatcher.whitespace().or(CharMatcher.is('-')), ' ')
            .withCustomRule(String::trim)
            .build();

    public static String replaceTemplateText(@Nullable String bannerText) {
        return CLEAN_BANNER_MODIFIER.makeReplacements(bannerText);
    }

    public static boolean keywordIsKnownToBs(Keyword keyword) {
        return !(keyword.getPhraseBsId() == null || BigInteger.ZERO.equals(keyword.getPhraseBsId()));
    }

    /**
     * protected/BSAuction.pm:_prepare_text
     */
    @Nullable
    public static String prepareText(@Nullable String keywordText) {
        return KEYWORD_MODIFIER.makeReplacements(keywordText);
    }
}
