package ru.yandex.direct.core.entity.autobroker.model;

import ru.yandex.direct.core.entity.keyword.model.Place;
import ru.yandex.direct.currency.Money;

/**
 * Результат работы Автоброкера.
 * <p>
 * Расчитывает фактически списываемую цену клка и сопутствующие параметры в зависимости
 * от текущих расценок на Торгах БК и кампании пользователя
 */
@SuppressWarnings("WeakerAccess")
public class AutoBrokerResult {

    private Money brokerPrice;
    private double brokerCoverage;
    private boolean brokerTruncated;
    private Place brokerPlace;
    private Place brokerPlaceWithoutCoef;

    public Money getBrokerPrice() {
        return brokerPrice;
    }

    public double getBrokerCoverage() {
        return brokerCoverage;
    }

    public boolean isBrokerTruncated() {
        return brokerTruncated;
    }

    public Place getBrokerPlace() {
        return brokerPlace;
    }

    public Place getBrokerPlaceWithoutCoef() {
        return brokerPlaceWithoutCoef;
    }

    public AutoBrokerResult withBrokerPrice(final Money brokerPrice) {
        setBrokerPrice(brokerPrice);
        return this;
    }

    public AutoBrokerResult withBrokerCoverage(final double brokerCoverage) {
        setBrokerCoverage(brokerCoverage);
        return this;
    }

    public AutoBrokerResult withBrokerTruncated(final boolean brokerTruncated) {
        setBrokerTruncated(brokerTruncated);
        return this;
    }

    public AutoBrokerResult withBrokerPlace(final Place brokerPlace) {
        setBrokerPlace(brokerPlace);
        return this;
    }

    public AutoBrokerResult withBrokerPlaceWithoutCoef(
            final Place brokerPlaceWithoutCoef) {
        setBrokerPlaceWithoutCoef(brokerPlaceWithoutCoef);
        return this;
    }

    public void setBrokerPrice(Money brokerPrice) {
        this.brokerPrice = brokerPrice;
    }

    public void setBrokerCoverage(double brokerCoverage) {
        this.brokerCoverage = brokerCoverage;
    }

    public void setBrokerTruncated(boolean brokerTruncated) {
        this.brokerTruncated = brokerTruncated;
    }

    public void setBrokerPlace(Place brokerPlace) {
        this.brokerPlace = brokerPlace;
    }

    public void setBrokerPlaceWithoutCoef(Place brokerPlaceWithoutCoef) {
        this.brokerPlaceWithoutCoef = brokerPlaceWithoutCoef;
    }

    @Override
    public String toString() {
        return "AutoBrokerResult{" +
                "brokerPrice=" + brokerPrice +
                ", brokerCoverage=" + brokerCoverage +
                ", brokerTruncated=" + brokerTruncated +
                ", brokerPlace=" + brokerPlace +
                ", brokerPlaceWithoutCoef=" + brokerPlaceWithoutCoef +
                '}';
    }
}
